/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import java.awt.Image;
import java.time.Duration;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.annotations.Layer1StrategyName;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public class Layer1ApiSoundAlertMessage
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    public static final long REPEAT_COUNT_INFINITE = Long.MAX_VALUE;
    public final byte[] sound;
    public final String textInfo;
    public final boolean showPopup;
    public final long repeatCount;
    public final Duration repeatDelay;
    public final String alertId;
    public final SoundAlertStatusListener statusListener;
    public final Class<?> source;
    public final Object metadata;
    public final String alias;
    public final String alertDeclarationId;
    public final int priority;
    public final String additionalInfo;
    public final Image severityIcon;
    private boolean isCancelMessage = false;

    private Layer1ApiSoundAlertMessage(Builder builder) {
        this.sound = builder.sound;
        this.textInfo = builder.textInfo;
        this.showPopup = builder.showPopup;
        this.repeatCount = builder.repeatCount;
        this.repeatDelay = builder.repeatDelay;
        this.alertId = IdHelper.generateShortUuid();
        this.statusListener = builder.statusListener;
        this.source = builder.source;
        this.metadata = builder.metadata;
        this.alias = builder.alias;
        this.priority = builder.priority;
        this.additionalInfo = builder.additionalInfo;
        this.alertDeclarationId = builder.alertDeclarationId;
        this.severityIcon = builder.severityIcon;
        if (this.source == null) {
            throw new IllegalArgumentException("source field is mandatory");
        }
        if (this.source.getAnnotation(Layer1StrategyName.class) == null) {
            throw new IllegalArgumentException("source is not annotated with " + Layer1StrategyName.class.getSimpleName() + ". Note that it must be the entry point class of the module submitting the alert.");
        }
        if (this.showPopup && this.textInfo == null) {
            throw new IllegalArgumentException("textInfo can't be null when showPopup is true");
        }
    }

    @Deprecated
    public Layer1ApiSoundAlertMessage(byte[] sound, String textInfo, long repeatCount, Duration repeatDelay, SoundAlertStatusListener statusListener, Class<?> source, Object metadata) {
        this.sound = sound;
        this.textInfo = textInfo;
        this.showPopup = false;
        this.repeatCount = repeatCount;
        this.repeatDelay = repeatDelay;
        this.alertId = IdHelper.generateShortUuid();
        this.statusListener = statusListener;
        this.source = source;
        this.metadata = metadata;
        this.alias = null;
        this.priority = 0;
        this.additionalInfo = null;
        this.severityIcon = null;
        this.alertDeclarationId = null;
    }

    @Deprecated
    public Layer1ApiSoundAlertMessage(String alertId) {
        this.sound = null;
        this.textInfo = null;
        this.showPopup = false;
        this.repeatCount = 0L;
        this.repeatDelay = null;
        this.alertId = alertId;
        this.statusListener = (a, s) -> {};
        this.source = null;
        this.metadata = null;
        this.alias = null;
        this.priority = 0;
        this.isCancelMessage = true;
        this.additionalInfo = null;
        this.alertDeclarationId = null;
        this.severityIcon = null;
    }

    public boolean isCancelMessage() {
        return this.isCancelMessage;
    }

    public String toString() {
        return "Layer1ApiSoundAlertMessage [textInfo='" + this.textInfo + "', showPopup=" + this.showPopup + ", repeatCount=" + this.repeatCount + ", repeatDelay=" + this.repeatDelay + ", alertId='" + this.alertId + "', source=" + this.source + ", metadata=" + this.metadata + ", alias='" + this.alias + "', alertDeclarationId='" + this.alertDeclarationId + "', priority=" + this.priority + ", additionalInfo='" + this.additionalInfo + "', isCancelMessage=" + this.isCancelMessage + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Layer1ApiPublic
    public static final class Builder {
        private byte[] sound;
        private String textInfo;
        private boolean showPopup;
        private long repeatCount = 1L;
        private Duration repeatDelay;
        private SoundAlertStatusListener statusListener;
        private Class<?> source;
        private Object metadata;
        private String alias;
        private int priority = 0;
        private String additionalInfo;
        private Image severityIcon = null;
        public String alertDeclarationId;

        private Builder() {
        }

        public Builder setSound(byte[] sound) {
            this.sound = sound;
            return this;
        }

        public Builder setTextInfo(String textInfo) {
            this.textInfo = textInfo;
            return this;
        }

        public Builder setShowPopup(boolean showPopup) {
            this.showPopup = showPopup;
            return this;
        }

        public Builder setRepeatCount(long repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        public Builder setRepeatDelay(Duration repeatDelay) {
            this.repeatDelay = repeatDelay;
            return this;
        }

        public Builder setStatusListener(SoundAlertStatusListener statusListener) {
            this.statusListener = statusListener;
            return this;
        }

        public Builder setSource(Class<?> source) {
            this.source = source;
            return this;
        }

        public Builder setMetadata(Object metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public Builder setSeverityIcon(Image icon) {
            this.severityIcon = icon;
            return this;
        }

        public Builder setAlertDeclarationId(String alertDeclarationId) {
            this.alertDeclarationId = alertDeclarationId;
            return this;
        }

        public Layer1ApiSoundAlertMessage build() {
            return new Layer1ApiSoundAlertMessage(this);
        }
    }

    @FunctionalInterface
    @Layer1ApiPublic
    public static interface SoundAlertStatusListener {
        public void onSoundAlertStatus(String var1, SoundAlertStatus var2);
    }

    @Layer1ApiPublic
    public static enum SoundAlertStatus {
        PENDING,
        AWAITING_REPEAT,
        PLAYING,
        DONE,
        POPUP_CLOSED;

    }
}

