/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.annotations;

import java.util.Arrays;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public enum Layer1ApiVersionValue {
    VERSION0(0),
    VERSION1(1),
    VERSION2(2);

    private final int numericValue;

    private Layer1ApiVersionValue(int numericValue) {
        this.numericValue = numericValue;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public static Layer1ApiVersionValue getHighestVersion() {
        Layer1ApiVersionValue[] values = Layer1ApiVersionValue.values();
        return values[values.length - 1];
    }

    public static Layer1ApiVersionValue valueOf(int numericValue) {
        return Arrays.stream(Layer1ApiVersionValue.values()).filter(v -> v.numericValue == numericValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Version " + numericValue + " not found"));
    }

    static {
        Layer1ApiVersionValue[] values = Layer1ApiVersionValue.values();
        for (int i = 1; i < values.length; ++i) {
            if (values[i - 1].numericValue < values[i].numericValue) continue;
            throw new IllegalStateException("Versions are declared in wrong order");
        }
    }
}

