/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class BalanceInfo {
    public final String accountName;
    public final List<BalanceInCurrency> balancesInCurrency;

    public BalanceInfo(String accountName, List<BalanceInCurrency> balancesInCurrency) {
        this.accountName = accountName;
        this.balancesInCurrency = Collections.unmodifiableList(new ArrayList<BalanceInCurrency>(balancesInCurrency));
    }

    public BalanceInfo(List<BalanceInCurrency> balancesInCurrency) {
        this(null, balancesInCurrency);
    }

    public String toString() {
        return this.getClass() + "{" + this.balancesInCurrency.toString() + "}";
    }

    @Layer1ApiPublic
    public static class BalanceInCurrency {
        public final double balance;
        public final double realizedPnl;
        public final double unrealizedPnl;
        public final double previousDayBalance;
        public final double netLiquidityValue;
        public final String currency;
        public final Double rateToBase;

        public BalanceInCurrency(double balance, double realizedPnl, double unrealizedPnl, double previousDayBalance, double netLiquidityValue, String currency, Double rateToBase) {
            this.balance = balance;
            this.realizedPnl = realizedPnl;
            this.unrealizedPnl = unrealizedPnl;
            this.previousDayBalance = previousDayBalance;
            this.netLiquidityValue = netLiquidityValue;
            this.currency = currency;
            this.rateToBase = rateToBase;
        }

        public String toString() {
            return "{balance=" + this.balance + ", realizedPnl=" + this.realizedPnl + ", unrealizedPnl=" + this.unrealizedPnl + ", previousDayBalance=" + this.previousDayBalance + ", netLiquidityValue=" + this.netLiquidityValue + ", currency=" + this.currency + ", rateToBase=" + this.rateToBase + "}";
        }
    }
}

