/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.io.Serializable;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class InstrumentCoreInfo
implements Serializable {
    private static final long serialVersionUID = 8348371739129190371L;
    public final String symbol;
    public final String exchange;
    public final String type;

    private InstrumentCoreInfo() {
        this(null, null, null);
    }

    public InstrumentCoreInfo(String symbol, String exchange, String type) {
        this.symbol = symbol;
        this.exchange = exchange;
        this.type = type;
    }

    public String toString() {
        return "InstrumentCoreInfo [symbol=" + this.symbol + ", exchange=" + this.exchange + ", type=" + this.type + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstrumentCoreInfo)) {
            return false;
        }
        InstrumentCoreInfo instrumentInfo = (InstrumentCoreInfo)obj;
        boolean symbolIsEquals = this.areEquals(instrumentInfo.symbol, this.symbol);
        boolean exchangeIsEquals = this.areEquals(instrumentInfo.exchange, this.exchange);
        boolean typeIsEquals = this.areEquals(instrumentInfo.type, this.type);
        return symbolIsEquals && exchangeIsEquals && typeIsEquals;
    }

    private boolean areEquals(String s1, String s2) {
        boolean nullOrEmpty2;
        boolean nullOrEmpty1 = s1 == null || s1.isEmpty();
        boolean bl = nullOrEmpty2 = s2 == null || s2.isEmpty();
        if (nullOrEmpty1 && nullOrEmpty2) {
            return true;
        }
        return s1 != null && s1.equals(s2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exchange == null || this.exchange.isEmpty() ? 0 : this.exchange.hashCode());
        result = 31 * result + (this.symbol == null || this.symbol.isEmpty() ? 0 : this.symbol.hashCode());
        result = 31 * result + (this.type == null || this.type.isEmpty() ? 0 : this.type.hashCode());
        return result;
    }
}

