/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Utils;
import velox.api.layer1.data.AbstractSimpleOrderSendParametersBuilder;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.OrderType;
import velox.api.layer1.data.SimpleOrderSendParametersBuilder;
import velox.api.layer1.data.SingleOrderSendParameters;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public class SimpleOrderSendParameters
extends SingleOrderSendParameters {
    public final double limitPrice;
    public final double stopPrice;
    public final int takeProfitOffset;
    public final int stopLossOffset;
    public final int stopLossTrailingStep;
    public final String takeProfitClientId;
    public final String stopLossClientId;
    public final int trailingStep;
    public final boolean doNotIncrease;
    public final boolean reversingPositionHint;
    public final boolean closingPositionHint;
    @Deprecated
    public double sizeMultiplier = Double.NaN;

    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, 0, 0, 0, -1, false);
    }

    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, int trailingStep, double limitPrice, double stopPrice) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, 0, 0, 0, trailingStep, false);
    }

    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease) {
        super(alias, isBuy, size, duration);
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
        this.takeProfitOffset = takeProfitOffset;
        this.stopLossOffset = stopLossOffset;
        this.stopLossTrailingStep = stopLossTrailingStep;
        this.takeProfitClientId = IdHelper.generateShortUuid();
        this.stopLossClientId = IdHelper.generateShortUuid();
        this.trailingStep = trailingStep;
        this.doNotIncrease = doNotIncrease;
        this.reversingPositionHint = false;
        this.closingPositionHint = false;
    }

    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, boolean reversingPositionHint, boolean closingPositionHint) {
        super(alias, isBuy, size, duration, clientId);
        this.limitPrice = limitPrice;
        this.stopPrice = stopPrice;
        this.takeProfitOffset = takeProfitOffset;
        this.stopLossOffset = stopLossOffset;
        this.stopLossTrailingStep = stopLossTrailingStep;
        this.takeProfitClientId = IdHelper.generateShortUuid();
        this.stopLossClientId = IdHelper.generateShortUuid();
        this.trailingStep = trailingStep;
        this.doNotIncrease = doNotIncrease;
        this.reversingPositionHint = reversingPositionHint;
        this.closingPositionHint = closingPositionHint;
    }

    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease) {
        this(alias, isBuy, size, duration, clientId, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease, false, false);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, double sizeMultiplier) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, int trailingStep, double limitPrice, double stopPrice, double sizeMultiplier) {
        this(alias, isBuy, size, duration, trailingStep, limitPrice, stopPrice);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, double sizeMultiplier) {
        this(alias, isBuy, size, duration, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease);
    }

    @Deprecated
    public SimpleOrderSendParameters(String alias, boolean isBuy, int size, OrderDuration duration, String clientId, double limitPrice, double stopPrice, int takeProfitOffset, int stopLossOffset, int stopLossTrailingStep, int trailingStep, boolean doNotIncrease, double sizeMultiplier) {
        this(alias, isBuy, size, duration, clientId, limitPrice, stopPrice, takeProfitOffset, stopLossOffset, stopLossTrailingStep, trailingStep, doNotIncrease);
    }

    public AbstractSimpleOrderSendParametersBuilder<SimpleOrderSendParametersBuilder> toBuilder() {
        return new SimpleOrderSendParametersBuilder(this.alias, this.isBuy, this.size, this.duration, this.clientId, this.limitPrice, this.stopPrice, this.takeProfitOffset, this.stopLossOffset, this.stopLossTrailingStep, this.trailingStep, this.doNotIncrease, this.reversingPositionHint, this.closingPositionHint);
    }

    @Override
    public String toString() {
        return this.getClass() + "{super=" + super.toString() + ", limitPrice=" + this.limitPrice + ", stopPrice=" + this.stopPrice + ", takeProfitOffset=" + this.takeProfitOffset + ", stopLossOffset=" + this.stopLossOffset + ", trailingStep=" + this.trailingStep + ", doNotIncrease=" + this.doNotIncrease + ", reversingPositionHint=" + this.reversingPositionHint + ", closingPositionHint=" + this.closingPositionHint + "}";
    }

    public String representation(PriceFormatter formatter, double sizeMultiplier) {
        OrderType type = OrderType.getTypeFromPrices(this.stopPrice, this.limitPrice);
        StringBuilder builder = new StringBuilder();
        builder.append(OrderType.STP == type ? OrderType.STP + " " + OrderType.MKT : type).append(" ");
        if (this.isBuy) {
            builder.append("BUY");
        } else {
            builder.append("SELL");
        }
        builder.append(" order");
        if (type != OrderType.MKT) {
            builder.append(" at ");
            builder.append(formatter.format(OrderType.STP == type || OrderType.STP_LMT == type ? this.stopPrice : this.limitPrice));
        }
        if (OrderType.STP_LMT == type) {
            builder.append(" with limit price ").append(formatter.format(this.limitPrice));
        }
        builder.append(", size ").append(Utils.doubleToString((double)((double)this.size / sizeMultiplier)));
        builder.append(" and duration ").append(this.duration.name());
        if (this.trailingStep > 0 && (OrderType.STP == type || OrderType.STP_LMT == type)) {
            builder.append(", trailing stop step equal to ").append(this.trailingStep).append(" ticks");
        }
        return builder.toString();
    }

    public static interface PriceFormatter {
        public String format(double var1);
    }
}

