/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.strategies.interfaces;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.helper.OpenGlHelper;
import velox.api.layer1.layers.strategies.interfaces.ScreenSpaceShapeListener;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public interface ScreenSpaceCanvas {
    public long getUniqueId();

    public void dispose();

    public void addShape(CanvasShape var1);

    public void removeShape(CanvasShape var1);

    @Layer1ApiPublic
    public static class RelativePixelHorizontalCoordinate
    extends RelativeHorizontalCoordinate {
        public RelativePixelHorizontalCoordinate(HorizontalCoordinate base, int offset) {
            super(base, offset, 0L);
        }
    }

    @Layer1ApiPublic
    public static class RelativeDataHorizontalCoordinate
    extends RelativeHorizontalCoordinate {
        public RelativeDataHorizontalCoordinate(HorizontalCoordinate base, long offset) {
            super(base, 0, offset);
        }
    }

    @Layer1ApiPublic
    public static class RelativePixelVerticalCoordinate
    extends RelativeVerticalCoordinate {
        public RelativePixelVerticalCoordinate(VerticalCoordinate base, int offset) {
            super(base, 0.0, offset);
        }
    }

    @Layer1ApiPublic
    public static class RelativeDataVerticalCoordinate
    extends RelativeVerticalCoordinate {
        public RelativeDataVerticalCoordinate(VerticalCoordinate base, double offset) {
            super(base, offset, 0);
        }
    }

    @Layer1ApiPublic
    public static class RelativeHorizontalCoordinate
    implements HorizontalCoordinate {
        public static final CompositeHorizontalCoordinate HORIZONTAL_DATA_ZERO = new CompositeHorizontalCoordinate(CompositeCoordinateBase.DATA_ZERO, 0, 0L);
        public static final CompositeHorizontalCoordinate HORIZONTAL_PIXEL_ZERO = new CompositeHorizontalCoordinate(CompositeCoordinateBase.PIXEL_ZERO, 0, 0L);
        public final HorizontalCoordinate base;
        public final int pixelsOffsetX;
        public final long timeOffsetX;

        public RelativeHorizontalCoordinate(HorizontalCoordinate base, int pixelsOffsetX, long timeOffsetX) {
            this.base = base;
            this.pixelsOffsetX = pixelsOffsetX;
            this.timeOffsetX = timeOffsetX;
        }

        @Override
        public CompositeHorizontalCoordinate compose() {
            CompositeHorizontalCoordinate composedBase = this.base.compose();
            return new CompositeHorizontalCoordinate(composedBase.base, composedBase.pixelsX + this.pixelsOffsetX, composedBase.timeX + this.timeOffsetX);
        }
    }

    @Layer1ApiPublic
    public static class RelativeVerticalCoordinate
    implements VerticalCoordinate {
        public static final CompositeVerticalCoordinate VERTICAL_DATA_ZERO = new CompositeVerticalCoordinate(CompositeCoordinateBase.DATA_ZERO, 0, 0.0);
        public static final CompositeVerticalCoordinate VERTICAL_PIXEL_ZERO = new CompositeVerticalCoordinate(CompositeCoordinateBase.PIXEL_ZERO, 0, 0.0);
        public final VerticalCoordinate base;
        public final double dataOffsetY;
        public final int pixelsOffsetY;

        protected RelativeVerticalCoordinate(VerticalCoordinate base, double dataOffsetY, int pixelsOffsetY) {
            this.base = base;
            this.dataOffsetY = dataOffsetY;
            this.pixelsOffsetY = pixelsOffsetY;
        }

        @Override
        public CompositeVerticalCoordinate compose() {
            CompositeVerticalCoordinate composedBase = this.base.compose();
            return new CompositeVerticalCoordinate(composedBase.base, composedBase.pixelsY + this.pixelsOffsetY, composedBase.dataY + this.dataOffsetY);
        }
    }

    @Layer1ApiPublic
    public static class CompositeHorizontalCoordinate
    implements HorizontalCoordinate {
        public final CompositeCoordinateBase base;
        public final int pixelsX;
        public final long timeX;

        public CompositeHorizontalCoordinate(CompositeCoordinateBase base, int pixelsX, long timeX) {
            this.base = base;
            this.pixelsX = pixelsX;
            this.timeX = timeX;
        }

        @Override
        public CompositeHorizontalCoordinate compose() {
            return this;
        }
    }

    @Layer1ApiPublic
    public static class CompositeVerticalCoordinate
    implements VerticalCoordinate {
        public final CompositeCoordinateBase base;
        public final int pixelsY;
        public final double dataY;

        public CompositeVerticalCoordinate(CompositeCoordinateBase base, int pixelsY, double dataY) {
            this.base = base;
            this.pixelsY = pixelsY;
            this.dataY = dataY;
        }

        @Override
        public CompositeVerticalCoordinate compose() {
            return this;
        }
    }

    @Layer1ApiPublic
    public static enum CompositeCoordinateBase {
        DATA_ZERO,
        PIXEL_ZERO,
        RELATIVE;

    }

    @Layer1ApiPublic
    public static interface HorizontalCoordinate {
        public CompositeHorizontalCoordinate compose();
    }

    @Layer1ApiPublic
    public static interface VerticalCoordinate {
        public CompositeVerticalCoordinate compose();
    }

    @Layer1ApiPublic
    public static class CanvasIcon
    extends BasicCanvasShape {
        private PreparedImage image;
        private HorizontalCoordinate x1;
        private VerticalCoordinate y1;
        private HorizontalCoordinate x2;
        private VerticalCoordinate y2;

        public CanvasIcon(PreparedImage image, HorizontalCoordinate x1, VerticalCoordinate y1, HorizontalCoordinate x2, VerticalCoordinate y2) {
            this.image = image;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public PreparedImage getImage() {
            return this.image;
        }

        public HorizontalCoordinate getX1() {
            return this.x1;
        }

        public VerticalCoordinate getY1() {
            return this.y1;
        }

        public HorizontalCoordinate getX2() {
            return this.x2;
        }

        public VerticalCoordinate getY2() {
            return this.y2;
        }

        @Override
        public CanvasIcon copy() {
            CanvasIcon copy = new CanvasIcon(this.image, this.x1, this.y1, this.x2, this.y2);
            copy.uniqueId = this.uniqueId;
            return copy;
        }

        public void setImage(PreparedImage icon) {
            this.image = icon;
            this.publishChange();
        }

        public void setX1(HorizontalCoordinate x1) {
            this.x1 = x1;
            this.publishChange();
        }

        public void setX2(HorizontalCoordinate x2) {
            this.x2 = x2;
            this.publishChange();
        }

        public void setY1(VerticalCoordinate y1) {
            this.y1 = y1;
            this.publishChange();
        }

        public void setY2(VerticalCoordinate y2) {
            this.y2 = y2;
            this.publishChange();
        }
    }

    @Layer1ApiPublic
    public static class PreparedImage {
        private final BufferedImage image;
        private final Future<int[]> openglRepresentation;

        public PreparedImage(BufferedImage image) {
            this.image = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics iconCopyGraphics = this.image.getGraphics();
            iconCopyGraphics.drawImage(image, 0, 0, null);
            iconCopyGraphics.dispose();
            this.openglRepresentation = OpenGlHelper.convertImageToOpenGlFormatAsync((BufferedImage)image);
        }

        public BufferedImage getReadOnlyImage() {
            return this.image;
        }

        public int[] getReadOnlyOpenglRepresentation() {
            try {
                return this.openglRepresentation.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to compute opengl representation", e);
            }
        }
    }

    @Layer1ApiPublic
    public static abstract class BasicCanvasShape
    implements CanvasShape {
        private ScreenSpaceShapeListener listener = null;
        protected long uniqueId = IdHelper.generateLongUniqueId();

        @Override
        public void setShapeListener(ScreenSpaceShapeListener listener) {
            if (this.listener != null) {
                throw new IllegalStateException("listener already set, shape can not be reused");
            }
            this.listener = listener;
        }

        @Override
        public long getUniqueId() {
            return this.uniqueId;
        }

        protected void publishChange() {
            if (this.listener != null) {
                this.listener.onShapeChange((CanvasShape)this);
            }
        }
    }

    @Layer1ApiPublic
    public static interface CanvasShape {
        public long getUniqueId();

        public void setShapeListener(ScreenSpaceShapeListener var1);

        public CanvasShape copy();
    }
}

