/*
 * Decompiled with CFR 0.152.
 */
package velox.gui;

import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JPanel;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.gui.utils.GuiUtils;

@Layer1ApiPublic
public class StrategyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final String title;
    private List<Runnable> reloadListeners = new ArrayList<Runnable>();

    public StrategyPanel(String title) {
        this.title = title;
    }

    public StrategyPanel(String title, boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.title = title;
    }

    public StrategyPanel(String title, LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.title = title;
    }

    public StrategyPanel(String title, LayoutManager layout) {
        super(layout);
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void setEnabled(boolean enabled) {
        GuiUtils.doForEachComponentInPanel(this, component -> {
            if (component != this) {
                component.setEnabled(enabled);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReload() {
        List<Runnable> list = this.reloadListeners;
        synchronized (list) {
            for (Runnable listener : this.reloadListeners) {
                listener.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReloadListener(Runnable reloadListener) {
        List<Runnable> list = this.reloadListeners;
        synchronized (list) {
            this.reloadListeners.add(reloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReloadListenersIf(Predicate<Runnable> listener) {
        List<Runnable> list = this.reloadListeners;
        synchronized (list) {
            this.reloadListeners.removeIf(listener);
        }
    }
}

