/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.ListenableHelper;
import velox.api.layer1.common.Log;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.DisconnectionReason;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.LoginFailedReason;
import velox.api.layer1.data.MarketMode;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.SystemTextMessageType;
import velox.api.layer1.data.TradeInfo;
import velox.api.layer1.layers.Layer1ApiRelay;

@Layer1ApiPublic
public class Layer1ApiInjectorRelay
extends Layer1ApiRelay {
    private final ExecutorService userMessageInjectorExecutor = Executors.newSingleThreadExecutor();
    protected final Object upstreamInjectorLock = new Object();

    public Layer1ApiInjectorRelay(Layer1ApiProvider provider) {
        super(provider, false);
        ListenableHelper.addListeners(provider, (Object)this);
    }

    protected void inject(Runnable r) {
        this.userMessageInjectorExecutor.execute(() -> this.injectSynchronously(r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectSynchronously(Runnable r) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            r.run();
        }
    }

    @Deprecated
    protected void safeInject(Runnable r) {
        this.userMessageInjectorExecutor.submit(() -> {
            Object object = this.upstreamInjectorLock;
            synchronized (object) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    Log.error("Task injection error", e);
                    throw e;
                }
            }
        });
    }

    @Override
    public void close() {
        super.close();
        this.userMessageInjectorExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onInstrumentAdded(alias, instrumentInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInstrumentRemoved(String alias) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onInstrumentRemoved(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInstrumentNotFound(String symbol, String exchange, String type) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onInstrumentNotFound(symbol, exchange, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInstrumentAlreadySubscribed(String symbol, String exchange, String type) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onInstrumentAlreadySubscribed(symbol, exchange, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onTrade(alias, price, size, tradeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDepth(String alias, boolean isBid, int price, int size) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onDepth(alias, isBid, price, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onMboSend(alias, orderId, isBid, price, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMboReplace(String alias, String orderId, int price, int size) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onMboReplace(alias, orderId, price, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMboCancel(String alias, String orderId) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onMboCancel(alias, orderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMarketMode(String alias, MarketMode marketMode) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onMarketMode(alias, marketMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onOrderUpdated(orderInfoUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOrderExecuted(ExecutionInfo executionInfo) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onOrderExecuted(executionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatus(StatusInfo statusInfo) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onStatus(statusInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBalance(BalanceInfo balanceInfo) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onBalance(balanceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoginFailed(LoginFailedReason reason, String message) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onLoginFailed(reason, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoginSuccessful() {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onLoginSuccessful();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionLost(DisconnectionReason reason, String message) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onConnectionLost(reason, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnectionRestored() {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onConnectionRestored();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSystemTextMessage(String message, SystemTextMessageType messageType) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onSystemTextMessage(message, messageType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUserMessage(Object data) {
        Object object = this.upstreamInjectorLock;
        synchronized (object) {
            super.onUserMessage(data);
        }
    }
}

