/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import marytts.LocalMaryInterface;
import marytts.MaryInterface;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Log;
import velox.api.layer1.layers.utils.TextPreprocessor;

@Layer1ApiPublic
public class SoundSynthHelper {
    private static final int INIT_ATTEMPTS_MAX_COUNT = 10;
    private static MaryInterface marytts;
    private static Semaphore initializedSemaphore;
    private static volatile boolean isAllMaryttsLoggersSetToWarn;

    public static synchronized void initialize() {
        try {
            System.setProperty("log4j.logger.marytts", "ERROR");
            int attemptsCount = 0;
            boolean success = false;
            do {
                ++attemptsCount;
                try {
                    marytts = new LocalMaryInterface();
                    success = true;
                }
                catch (MaryConfigurationException e) {
                    Log.error("When initializing marrytts: " + (Object)((Object)e) + ", will try again");
                }
            } while (!success && attemptsCount < 10);
            LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
            for (Logger logger : logContext.getLoggers()) {
                if (!logger.getName().startsWith("marytts.")) continue;
                Configurator.setLevel((String)logger.getName(), (Level)Level.WARN);
            }
            if (marytts != null) {
                marytts.setVoice("cmu-bdl-hsmm");
            } else {
                Log.error("marrytts: max attempts count reached. synthesize won't work");
            }
            SoundSynthHelper.setMaryttsLoggersToWarn();
            initializedSemaphore.release();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setMaryttsLoggersToWarnIfNotSet() {
        if (!isAllMaryttsLoggersSetToWarn) {
            Log.info("Settings marytts loggers to warn");
            SoundSynthHelper.setMaryttsLoggersToWarn();
            isAllMaryttsLoggersSetToWarn = true;
        }
    }

    private static void setMaryttsLoggersToWarn() {
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        for (Logger logger : logContext.getLoggers()) {
            if (!logger.getName().startsWith("marytts.")) continue;
            Configurator.setLevel((String)logger.getName(), (Level)Level.WARN);
        }
    }

    public static void waitUntilInitialized() throws InterruptedException {
        initializedSemaphore.acquire();
        initializedSemaphore.release();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] synthesize(String text) {
        if (marytts == null) {
            Log.warn("Synthesize is disabled due to initialization error: " + text);
            return new byte[0];
        }
        Log.info("Synthesize: " + text);
        text = TextPreprocessor.preprocess((String)text);
        if (!text.trim().isEmpty()) {
            try (AudioInputStream audioInputStream = marytts.generateAudio(text);){
                byte[] byArray;
                try (ByteArrayOutputStream soundBytes = new ByteArrayOutputStream();){
                    AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, soundBytes);
                    SoundSynthHelper.setMaryttsLoggersToWarnIfNotSet();
                    byArray = soundBytes.toByteArray();
                }
                return byArray;
            }
            catch (IOException | SynthesisException e) {
                throw new RuntimeException("Speach synthesis unexpectedly failed", e);
            }
        }
        return new byte[0];
    }

    public static synchronized void say(String text) {
        byte[] data = SoundSynthHelper.synthesize(text);
        try (AudioInputStream audio = AudioSystem.getAudioInputStream(new ByteArrayInputStream(data));){
            Clip clip = AudioSystem.getClip();
            clip.open(audio);
            clip.start();
            final Semaphore semaphore = new Semaphore(0);
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        semaphore.release();
                    }
                }
            });
            semaphore.acquire();
            clip.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        initializedSemaphore = new Semaphore(0);
        isAllMaryttsLoggersSetToWarn = false;
    }
}

