/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.commons.lang3.SystemUtils;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Log;

@Layer1ApiPublic
public class DirectoryResolver {
    private static final String WORK_DIR = DirectoryResolver.workDir();
    private static final String BOOKMAP_USER_HOME = DirectoryResolver.bookmapUserHome();

    public static Path getBookmapRootDirectory() {
        return Paths.get(BOOKMAP_USER_HOME, new String[0]).toAbsolutePath();
    }

    public static Path getBookmapDirectoryByName(String folderName) {
        return DirectoryResolver.getBookmapRootDirectory().resolve(folderName).toAbsolutePath();
    }

    public static Path getConfigDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Config");
    }

    public static Path getLogsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Logs");
    }

    public static Path getFeedsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Feeds");
    }

    public static Path getErrorReportsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Error reports");
    }

    public static Path getScreenshotsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Screenshots");
    }

    public static Path getDiagnosticLogsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Diagnostics logs");
    }

    public static Path getSoundsDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Sounds");
    }

    public static Path getLayer0ApiModulesDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("API").resolve("Layer0ApiModules");
    }

    public static Path getLayer1ApiModulesDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("API").resolve("Layer1ApiModules");
    }

    public static Path getCacheDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Cache");
    }

    public static Path getDataLibraryDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Data library");
    }

    public static Path getTemporaryDirectory() {
        return DirectoryResolver.getBookmapDirectoryByName("Temp");
    }

    public static Path getNativeErrorLogsDirectory() {
        return DirectoryResolver.getConfigDirectory();
    }

    private static String workDir() {
        return SystemUtils.IS_OS_MAC ? Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library/Application Support/Bookmap/Config").toString() : System.getProperty("user.dir");
    }

    private static String bookmapUserHome() {
        Path workDirPath = Paths.get(WORK_DIR, new String[0]);
        if (workDirPath.endsWith("Config")) {
            return workDirPath.getParent().toAbsolutePath().toString();
        }
        return workDirPath.toAbsolutePath().toString();
    }

    public static void setPermissions(Path path, PosixFilePermission ... permissions) {
        try {
            if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
                Log.info("Set permissions: " + path);
                Files.setPosixFilePermissions(path, EnumSet.copyOf(Arrays.asList(permissions)));
            }
        }
        catch (IOException e) {
            Log.warn("Cannot set permissions for: " + path, e);
        }
    }

    static {
        try {
            Path configDir = DirectoryResolver.getConfigDirectory();
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
                DirectoryResolver.setPermissions(configDir, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

