/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.OrderStatus;
import velox.api.layer1.data.OrderType;

@Layer1ApiPublic
public class OrderInfoBuilder {
    private String instrumentAlias;
    private String orderId;
    private boolean isBuy;
    private OrderType type;
    private String clientId;
    private String exchangeId;
    private boolean doNotIncrease;
    private int filled;
    private boolean filledChanged = false;
    private int unfilled;
    private boolean unfilledChanged = false;
    private double averageFillPrice = Double.NaN;
    private boolean averageFillPriceChanged = false;
    private OrderDuration duration;
    private boolean durationChanged = false;
    private OrderStatus status;
    private boolean statusChanged = false;
    private double limitPrice = Double.NaN;
    private boolean limitPriceChanged = false;
    private double stopPrice = Double.NaN;
    private boolean stopPriceChanged = false;
    private boolean stopTriggered;
    private boolean stopTriggeredChanged = false;
    private long modificationUtcTime = 0L;
    private boolean modificationTimeChanged = false;
    private boolean isSimulated;
    private boolean isDuplicate;

    public OrderInfoBuilder(String instrumentAlias, String orderId, boolean isBuy, OrderType type, String clientId, boolean doNotIncrease) {
        this.instrumentAlias = instrumentAlias;
        this.orderId = orderId;
        this.isBuy = isBuy;
        this.type = type;
        this.clientId = clientId;
        this.doNotIncrease = doNotIncrease;
    }

    OrderInfoBuilder(String instrumentAlias, String orderId, boolean isBuy, OrderType type, String clientId, String exchangeId, boolean doNotIncrease, int filled, boolean filledChanged, int unfilled, boolean unfilledChanged, double averageFillPrice, boolean averageFillPriceChanged, OrderDuration duration, boolean durationChanged, OrderStatus status, boolean statusChanged, double limitPrice, boolean limitPriceChanged, double stopPrice, boolean stopPriceChanged, boolean stopTriggered, boolean stopTriggeredChanged, long modificationUtcTime, boolean modificationTimeChanged, boolean isSimulated, boolean isDuplicate) {
        this(instrumentAlias, orderId, isBuy, type, clientId, doNotIncrease);
        this.exchangeId = exchangeId;
        this.filled = filled;
        this.filledChanged = filledChanged;
        this.unfilled = unfilled;
        this.unfilledChanged = unfilledChanged;
        this.averageFillPrice = averageFillPrice;
        this.averageFillPriceChanged = averageFillPriceChanged;
        this.duration = duration;
        this.durationChanged = durationChanged;
        this.status = status;
        this.statusChanged = statusChanged;
        this.limitPrice = limitPrice;
        this.limitPriceChanged = limitPriceChanged;
        this.stopPrice = stopPrice;
        this.stopPriceChanged = stopPriceChanged;
        this.stopTriggered = stopTriggered;
        this.stopTriggeredChanged = stopTriggeredChanged;
        this.modificationUtcTime = modificationUtcTime;
        this.modificationTimeChanged = modificationTimeChanged;
        this.isSimulated = isSimulated;
        this.isDuplicate = isDuplicate;
    }

    public String getInstrumentAlias() {
        return this.instrumentAlias;
    }

    public OrderInfoBuilder setInstrumentAlias(String instrumentAlias) {
        this.instrumentAlias = instrumentAlias;
        return this;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public OrderInfoBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public boolean isBuy() {
        return this.isBuy;
    }

    public OrderInfoBuilder setBuy(boolean isBuy) {
        this.isBuy = isBuy;
        return this;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderInfoBuilder setType(OrderType type) {
        this.type = type;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OrderInfoBuilder setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public OrderInfoBuilder setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
        return this;
    }

    public boolean isDoNotIncrease() {
        return this.doNotIncrease;
    }

    public OrderInfoBuilder setDoNotIncrease(boolean doNotIncrease) {
        this.doNotIncrease = doNotIncrease;
        return this;
    }

    public int getFilled() {
        return this.filled;
    }

    public OrderInfoBuilder setFilled(int filled) {
        this.filledChanged = this.filledChanged || filled != this.filled;
        this.filled = filled;
        return this;
    }

    public int getUnfilled() {
        return this.unfilled;
    }

    public OrderInfoBuilder setUnfilled(int unfilled) {
        this.unfilledChanged = this.unfilledChanged || unfilled != this.unfilled;
        this.unfilled = unfilled;
        return this;
    }

    public double getAverageFillPrice() {
        return this.averageFillPrice;
    }

    public OrderInfoBuilder setAverageFillPrice(double averageFillPrice) {
        this.averageFillPrice = averageFillPrice;
        return this;
    }

    public OrderDuration getDuration() {
        return this.duration;
    }

    public OrderInfoBuilder setDuration(OrderDuration duration) {
        this.duration = duration;
        return this;
    }

    public OrderStatus getStatus() {
        return this.status;
    }

    public OrderInfoBuilder setStatus(OrderStatus status) {
        this.status = status;
        return this;
    }

    public double getLimitPrice() {
        return this.limitPrice;
    }

    public OrderInfoBuilder setLimitPrice(double limitPrice) {
        this.limitPrice = limitPrice;
        return this;
    }

    public double getStopPrice() {
        return this.stopPrice;
    }

    public OrderInfoBuilder setStopPrice(double stopPrice) {
        this.stopPrice = stopPrice;
        return this;
    }

    public boolean isStopTriggered() {
        return this.stopTriggered;
    }

    public OrderInfoBuilder setStopTriggered(boolean isStopTriggered) {
        this.stopTriggered = isStopTriggered;
        return this;
    }

    public long getModificationUtcTime() {
        return this.modificationUtcTime;
    }

    public OrderInfoBuilder setModificationUtcTime(long modificationUtcTime) {
        this.modificationUtcTime = modificationUtcTime;
        return this;
    }

    public boolean isSimulated() {
        return this.isSimulated;
    }

    public OrderInfoBuilder setSimulated(boolean isSimulated) {
        this.isSimulated = isSimulated;
        return this;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public OrderInfoBuilder setDuplicate(boolean isDuplicate) {
        this.isDuplicate = isDuplicate;
        return this;
    }

    public OrderInfoBuilder markAllChanged() {
        this.filledChanged = true;
        this.unfilledChanged = true;
        this.averageFillPriceChanged = true;
        this.durationChanged = true;
        this.statusChanged = true;
        this.limitPriceChanged = true;
        this.stopPriceChanged = true;
        this.stopTriggeredChanged = true;
        this.modificationTimeChanged = true;
        return this;
    }

    public OrderInfoBuilder markAllUnchanged() {
        this.filledChanged = false;
        this.unfilledChanged = false;
        this.averageFillPriceChanged = false;
        this.durationChanged = false;
        this.statusChanged = false;
        this.limitPriceChanged = false;
        this.stopPriceChanged = false;
        this.stopTriggeredChanged = false;
        this.modificationTimeChanged = false;
        return this;
    }

    public OrderInfoUpdate build() {
        return new OrderInfoUpdate(this.instrumentAlias, this.orderId, this.isBuy, this.type, this.clientId, this.exchangeId, this.doNotIncrease, this.filled, this.filledChanged, this.unfilled, this.unfilledChanged, this.averageFillPrice, this.averageFillPriceChanged, this.duration, this.durationChanged, this.status, this.statusChanged, this.limitPrice, this.limitPriceChanged, this.stopPrice, this.stopPriceChanged, this.stopTriggered, this.stopTriggeredChanged, this.modificationUtcTime, this.modificationTimeChanged, this.isSimulated, this.isDuplicate);
    }
}

