/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.strategies.interfaces;

import java.awt.event.MouseEvent;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.layers.strategies.interfaces.CanvasPixelToDataBiMapper;
import velox.api.layer1.layers.strategies.interfaces.ScreenSpaceCanvas;

@Layer1ApiPublic
public class CanvasMouseEvent {
    private final CanvasPixelToDataBiMapper mapper;
    public final MouseEvent sourceEvent;

    public CanvasMouseEvent(CanvasPixelToDataBiMapper mapper, MouseEvent sourceEvent) {
        this.mapper = mapper;
        this.sourceEvent = sourceEvent;
    }

    public ScreenSpaceCanvas.CompositeHorizontalCoordinate getX(ScreenSpaceCanvas.HorizontalCoordinate relativeTo, CoordinateRequestType requestType) {
        ScreenSpaceCanvas.RelativeHorizontalCoordinate coordinate;
        ScreenSpaceCanvas.CompositeHorizontalCoordinate composedBase = relativeTo.compose();
        int relativeX = this.mapper.getRelativeX(this.sourceEvent.getX());
        long heatmapTimeLeft = this.mapper.getTime(0);
        int pixelsDeltaOffset = relativeX - composedBase.pixelsX;
        long timeDeltaOffset = this.mapper.getTime(relativeX) - composedBase.timeX;
        switch (composedBase.base) {
            case DATA_ZERO: {
                pixelsDeltaOffset = (int)Math.min((long)pixelsDeltaOffset + (long)this.mapper.getX(heatmapTimeLeft), Integer.MAX_VALUE);
                break;
            }
            case PIXEL_ZERO: {
                timeDeltaOffset -= heatmapTimeLeft;
                break;
            }
            case RELATIVE: {
                throw new IllegalArgumentException("Cannot calculate a coordinate based on coordinate with base " + ScreenSpaceCanvas.CompositeCoordinateBase.RELATIVE + ", use " + ScreenSpaceCanvas.CompositeCoordinateBase.PIXEL_ZERO + " or " + ScreenSpaceCanvas.CompositeCoordinateBase.DATA_ZERO + " instead");
            }
            default: {
                throw new IllegalArgumentException("Unknown base type: " + composedBase.base);
            }
        }
        switch (requestType) {
            case DATA: {
                coordinate = new ScreenSpaceCanvas.RelativeHorizontalCoordinate(relativeTo, 0, timeDeltaOffset);
                break;
            }
            case PIXELS: {
                coordinate = new ScreenSpaceCanvas.RelativeHorizontalCoordinate(relativeTo, pixelsDeltaOffset, 0L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + requestType);
            }
        }
        return coordinate.compose();
    }

    public ScreenSpaceCanvas.CompositeVerticalCoordinate getY(ScreenSpaceCanvas.VerticalCoordinate relativeTo, CoordinateRequestType requestType) {
        ScreenSpaceCanvas.RelativeVerticalCoordinate coordinate;
        ScreenSpaceCanvas.CompositeVerticalCoordinate composedBase = relativeTo.compose();
        int relativeY = this.mapper.getRelativeY(this.sourceEvent.getY());
        double heatmapPriceBottom = this.mapper.getPriceExact(0);
        int pixelsDeltaOffset = relativeY - composedBase.pixelsY;
        double priceDeltaOffset = this.mapper.getPriceExact(relativeY) - composedBase.dataY;
        switch (composedBase.base) {
            case DATA_ZERO: {
                pixelsDeltaOffset = (int)Math.min((long)pixelsDeltaOffset + (long)this.mapper.getY(heatmapPriceBottom), Integer.MAX_VALUE);
                break;
            }
            case PIXEL_ZERO: {
                priceDeltaOffset -= heatmapPriceBottom;
                break;
            }
            case RELATIVE: {
                throw new IllegalArgumentException("Cannot calculate a coordinate based on coordinate with base " + ScreenSpaceCanvas.CompositeCoordinateBase.RELATIVE + ", use " + ScreenSpaceCanvas.CompositeCoordinateBase.PIXEL_ZERO + " or " + ScreenSpaceCanvas.CompositeCoordinateBase.DATA_ZERO + " instead");
            }
            default: {
                throw new IllegalArgumentException("Unknown base type: " + composedBase.base);
            }
        }
        switch (requestType) {
            case DATA: {
                coordinate = new ScreenSpaceCanvas.RelativeVerticalCoordinate(relativeTo, priceDeltaOffset, 0);
                break;
            }
            case PIXELS: {
                coordinate = new ScreenSpaceCanvas.RelativeVerticalCoordinate(relativeTo, 0.0, pixelsDeltaOffset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown request type: " + requestType);
            }
        }
        return coordinate.compose();
    }

    public String toString() {
        return "CanvasMouseEvent{, sourceEvent=" + this.sourceEvent + "}";
    }

    @Layer1ApiPublic
    public static enum CoordinateRequestType {
        DATA,
        PIXELS;

    }
}

