/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.annotations.Layer1StrategyName;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public class Layer1ApiAlertSettingsMessage
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    public final String id;
    public final String declarationId;
    public final boolean popup;
    public final boolean sound;
    public final Class<?> source;

    private Layer1ApiAlertSettingsMessage(Builder builder) {
        this.id = builder.id;
        this.declarationId = builder.declarationId;
        this.popup = builder.popup;
        this.sound = builder.sound;
        this.source = builder.source;
        if (this.source == null) {
            throw new IllegalArgumentException("source field is mandatory");
        }
        if (this.source.getAnnotation(Layer1StrategyName.class) == null) {
            throw new IllegalArgumentException("source is not annotated with " + Layer1StrategyName.class.getSimpleName() + ". Note that it must be the entry point class of the module submitting the settings message.");
        }
    }

    public static Layer1ApiAlertSettingsMessage defaultSettings(String declarationId, Class<?> source) {
        return Layer1ApiAlertSettingsMessage.builder().setDeclarationId(declarationId).setPopup(false).setSound(false).setSource(source).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Layer1ApiAlertSettingsMessage [id=" + this.id + ", declarationId=" + this.declarationId + ", popup=" + this.popup + ", sound=" + this.sound + ", source=" + this.source + "]";
    }

    @Layer1ApiPublic
    public static final class Builder {
        private String id = IdHelper.generateShortUuid();
        private boolean popup;
        private boolean sound;
        private String declarationId;
        private Class<?> source;

        private Builder() {
        }

        public Builder(Layer1ApiAlertSettingsMessage message) {
            this.id = message.id;
            this.popup = message.popup;
            this.sound = message.sound;
            this.declarationId = message.declarationId;
            this.source = message.source;
        }

        public Builder setPopup(boolean popup) {
            this.popup = popup;
            return this;
        }

        public Builder setSound(boolean sound) {
            this.sound = sound;
            return this;
        }

        public Builder setDeclarationId(String declarationId) {
            this.declarationId = declarationId;
            return this;
        }

        public Builder setSource(Class<?> source) {
            this.source = source;
            return this;
        }

        public Layer1ApiAlertSettingsMessage build() {
            return new Layer1ApiAlertSettingsMessage(this);
        }
    }
}

