/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.NanoClock;

@Layer1ApiPublic
public class Layer1ApiTimeFreeze {
    public final long maxFreezeTimeNs;
    public final Class<?> owner;
    private boolean resumed = false;
    private long expirationTime = -1L;

    public Layer1ApiTimeFreeze(long maxFreezeTimeNs, Class<?> owner) {
        this.maxFreezeTimeNs = maxFreezeTimeNs;
        this.owner = owner;
    }

    public void beginExpirationCountdown() {
        if (this.expirationTime == -1L) {
            this.expirationTime = NanoClock.currentTimeNanos() + this.maxFreezeTimeNs;
        }
    }

    public void resume() {
        this.resumed = true;
    }

    public boolean isResumed() {
        if (NanoClock.currentTimeNanos() > this.expirationTime) {
            this.resume();
        }
        return this.resumed;
    }

    public String toString() {
        return "Layer1ApiTimeFreeze [maxFreezeTimeNs=" + this.maxFreezeTimeNs + ", owner=" + this.owner + ", resumed=" + this.resumed + ", expirationTime=" + this.expirationTime + ", hash=" + this.hashCode() + "]";
    }
}

