/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import velox.api.layer1.Layer1ApiAdminListener;
import velox.api.layer1.Layer1ApiAdminListenerBroadcaster;
import velox.api.layer1.Layer1ApiDataListener;
import velox.api.layer1.Layer1ApiDataListenerBroadcaster;
import velox.api.layer1.Layer1ApiInstrumentListener;
import velox.api.layer1.Layer1ApiInstrumentListenerBroadcaster;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.Layer1ApiTradingListener;
import velox.api.layer1.Layer1ApiTradingListenerBroadcaster;
import velox.api.layer1.LayerApiListenable;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class Layer1ApiBasicListenable
implements LayerApiListenable {
    protected final List<Layer1ApiInstrumentListener> instrumentListeners = new CopyOnWriteArrayList<Layer1ApiInstrumentListener>();
    protected final List<Layer1ApiDataListener> dataListeners = new CopyOnWriteArrayList<Layer1ApiDataListener>();
    protected final List<Layer1ApiMboDataListener> mboDataListeners = new CopyOnWriteArrayList<Layer1ApiMboDataListener>();
    protected final List<Layer1ApiTradingListener> tradingListeners = new CopyOnWriteArrayList<Layer1ApiTradingListener>();
    protected final List<Layer1ApiAdminListener> adminListeners = new CopyOnWriteArrayList<Layer1ApiAdminListener>();
    protected Layer1ApiInstrumentListener theOnlyInstrumentListener = null;
    protected Layer1ApiDataListener theOnlyDataListener = null;
    protected Layer1ApiMboDataListener theOnlyMboDataListener = null;
    protected Layer1ApiTradingListener theOnlyTradingListener = null;
    protected Layer1ApiAdminListener theOnlyAdminListener = null;

    private void callMethodIfForgotten() {
        boolean isForgotten;
        boolean bl = isForgotten = this.adminListeners.isEmpty() && this.dataListeners.isEmpty() && this.mboDataListeners.isEmpty() && this.instrumentListeners.isEmpty() && this.tradingListeners.isEmpty();
        if (isForgotten) {
            this.onNoSubscribers();
        }
    }

    protected void onNoSubscribers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Layer1ApiInstrumentListener listener) {
        List<Layer1ApiInstrumentListener> list = this.instrumentListeners;
        synchronized (list) {
            if (!this.instrumentListeners.contains(listener)) {
                this.instrumentListeners.add(listener);
                this.updateTheOnlyInstrumentListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Layer1ApiInstrumentListener listener) {
        List<Layer1ApiInstrumentListener> list = this.instrumentListeners;
        synchronized (list) {
            this.instrumentListeners.remove(listener);
            this.updateTheOnlyInstrumentListener();
        }
        this.callMethodIfForgotten();
    }

    private void updateTheOnlyInstrumentListener() {
        this.theOnlyInstrumentListener = this.instrumentListeners.size() == 1 ? this.instrumentListeners.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Layer1ApiDataListener listener) {
        List<Layer1ApiDataListener> list = this.dataListeners;
        synchronized (list) {
            if (!this.dataListeners.contains(listener)) {
                this.dataListeners.add(listener);
                this.updateTheOnlyDataListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Layer1ApiDataListener listener) {
        List<Layer1ApiDataListener> list = this.dataListeners;
        synchronized (list) {
            this.dataListeners.remove(listener);
            this.updateTheOnlyDataListener();
        }
        this.callMethodIfForgotten();
    }

    private void updateTheOnlyDataListener() {
        this.theOnlyDataListener = this.dataListeners.size() == 1 ? this.dataListeners.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Layer1ApiMboDataListener listener) {
        List<Layer1ApiMboDataListener> list = this.mboDataListeners;
        synchronized (list) {
            if (!this.mboDataListeners.contains(listener)) {
                this.mboDataListeners.add(listener);
                this.updateTheOnlyMboDataListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Layer1ApiMboDataListener listener) {
        List<Layer1ApiMboDataListener> list = this.mboDataListeners;
        synchronized (list) {
            this.mboDataListeners.remove(listener);
            this.updateTheOnlyMboDataListener();
        }
        this.callMethodIfForgotten();
    }

    private void updateTheOnlyMboDataListener() {
        this.theOnlyMboDataListener = this.mboDataListeners.size() == 1 ? this.mboDataListeners.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Layer1ApiTradingListener listener) {
        List<Layer1ApiTradingListener> list = this.tradingListeners;
        synchronized (list) {
            if (!this.tradingListeners.contains(listener)) {
                this.tradingListeners.add(listener);
                this.updateTheOnlyTradingListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Layer1ApiTradingListener listener) {
        List<Layer1ApiTradingListener> list = this.tradingListeners;
        synchronized (list) {
            this.tradingListeners.remove(listener);
            this.updateTheOnlyTradingListener();
        }
        this.callMethodIfForgotten();
    }

    private void updateTheOnlyTradingListener() {
        this.theOnlyTradingListener = this.tradingListeners.size() == 1 ? this.tradingListeners.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Layer1ApiAdminListener listener) {
        List<Layer1ApiAdminListener> list = this.adminListeners;
        synchronized (list) {
            if (!this.adminListeners.contains(listener)) {
                this.adminListeners.add(listener);
                this.updateTheOnlyAdminListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Layer1ApiAdminListener listener) {
        List<Layer1ApiAdminListener> list = this.adminListeners;
        synchronized (list) {
            this.adminListeners.remove(listener);
            this.updateTheOnlyAdminListener();
        }
        this.callMethodIfForgotten();
    }

    private void updateTheOnlyAdminListener() {
        this.theOnlyAdminListener = this.adminListeners.size() == 1 ? this.adminListeners.get(0) : null;
    }

    public int getUniqueListenersCount() {
        ArrayList<Object> listeners = new ArrayList<Object>();
        listeners.removeAll(this.instrumentListeners);
        listeners.addAll(this.instrumentListeners);
        listeners.removeAll(this.dataListeners);
        listeners.addAll(this.dataListeners);
        listeners.removeAll(this.tradingListeners);
        listeners.addAll(this.tradingListeners);
        listeners.removeAll(this.adminListeners);
        listeners.addAll(this.adminListeners);
        return listeners.size();
    }

    public Layer1ApiAdminListener getAdminListenerBroadcaster() {
        return new Layer1ApiAdminListenerBroadcaster(this.adminListeners);
    }

    public Layer1ApiInstrumentListener getInstrumentListenerBroadcaster() {
        return new Layer1ApiInstrumentListenerBroadcaster(this.instrumentListeners);
    }

    public Layer1ApiTradingListener getTradingListenerBroadcaster() {
        return new Layer1ApiTradingListenerBroadcaster(this.tradingListeners);
    }

    public Layer1ApiDataListener getDataListenerBroadcaster() {
        return new Layer1ApiDataListenerBroadcaster(this.dataListeners);
    }
}

