/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common.temporaryfiles;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Log;
import velox.api.layer1.common.temporaryfiles.TemporaryFileDirectory;

@Layer1ApiPublic
public class TemporaryFile {
    static final String LOCK_EXTENSION = ".lock";
    private final Path path;
    private boolean isDirectory;
    private File lockFile;
    private RandomAccessFile lockRaFile;
    private FileLock lock;

    public TemporaryFile(Path pathToFile, boolean isDirectory) {
        this(TemporaryFileDirectory.DEFAULT_TEMPORARY_DIRECTORY, pathToFile, isDirectory);
    }

    protected TemporaryFile(TemporaryFileDirectory temporaryFolder, Path filePathRelativeToFolder, boolean isDirectory) {
        Path root = temporaryFolder.getRoot();
        this.path = root.resolve(filePathRelativeToFolder).toAbsolutePath().normalize();
        this.isDirectory = isDirectory;
        if (this.path.getNameCount() <= root.getNameCount() || !this.path.startsWith(root)) {
            throw new IllegalArgumentException("Requested path is outside of root directory");
        }
    }

    public Path getPath() {
        return this.path;
    }

    public void create() {
        this.lockFile = this.path.resolveSibling(this.path.getFileName() + LOCK_EXTENSION).toFile();
        try {
            this.lockRaFile = new RandomAccessFile(this.lockFile, "rw");
            this.lock = this.lockRaFile.getChannel().tryLock();
            if (this.isDirectory) {
                Files.createDirectory(this.path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        this.dispose(true, true);
    }

    public void dispose(boolean removeFile, boolean throwException) {
        try {
            if (removeFile) {
                if (this.isDirectory) {
                    FileUtils.deleteDirectory((File)this.path.toFile());
                } else {
                    Files.delete(this.path);
                }
            }
            if (this.lock != null && this.lock.isValid()) {
                this.lock.release();
            }
            if (this.lockRaFile != null) {
                this.lockRaFile.close();
            }
            this.lockFile.delete();
        }
        catch (IOException e) {
            if (throwException) {
                throw new RuntimeException(e);
            }
            Log.warn("Failed to dispose " + this.path);
        }
    }
}

