/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.providers;

import java.util.HashMap;
import velox.api.layer1.annotations.PublishWithoutJavadoc;
import velox.api.layer1.data.OrderInfo;
import velox.api.layer1.data.OrderStatus;

@PublishWithoutJavadoc
public class WorkingOrdersCounter {
    private final HashMap<String, Integer> workingSells = new HashMap();
    private final HashMap<String, Integer> workingBuys = new HashMap();
    private int workingSellsCount = 0;
    private int workingBuysCount = 0;

    public synchronized int getWorkingBuys() {
        return this.workingBuysCount;
    }

    public synchronized int getWorkingSells() {
        return this.workingSellsCount;
    }

    public synchronized void onOrderUpdated(OrderInfo info) {
        if (info.isBuy) {
            Integer oldUnfilled = this.workingBuys.get(info.orderId);
            if (oldUnfilled != null) {
                this.workingBuysCount -= oldUnfilled.intValue();
            }
        } else {
            Integer oldUnfilled = this.workingSells.get(info.orderId);
            if (oldUnfilled != null) {
                this.workingSellsCount -= oldUnfilled.intValue();
            }
        }
        if (info.status == OrderStatus.WORKING) {
            if (info.isBuy) {
                this.workingBuys.put(info.orderId, info.unfilled);
                this.workingBuysCount += info.unfilled;
            } else {
                this.workingSells.put(info.orderId, info.unfilled);
                this.workingSellsCount += info.unfilled;
            }
        } else {
            (info.isBuy ? this.workingBuys : this.workingSells).remove(info.orderId);
        }
    }
}

