/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.util.Arrays;
import java.util.Date;
import velox.api.layer1.annotations.DontObfuscate;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.NanoClock;

@Layer1ApiPublic
public class Log {
    private static String messagePrefix = "";
    private static final boolean ALLOW_PERFLOG = true;
    private static LogListener listener = new SimpleConsoleLogger();
    private static LogLevel logLevel = LogLevel.TRACE;
    private static boolean tradeLevel = true;
    private static boolean errorLevel = true;
    private static boolean warnLevel = true;
    private static boolean infoLevel = true;
    private static boolean debugLevel = true;
    private static boolean traceLevel = true;
    private static long lastPerflogEntryTime = 0L;

    public static void setListener(LogListener listener) {
        Log.listener = listener;
    }

    public static LogListener getListener() {
        return listener;
    }

    public static void setLogLevel(LogLevel logLevel) {
        Log.logLevel = logLevel;
        tradeLevel = logLevel.levelAsInt <= LogLevel.TRADING.levelAsInt;
        errorLevel = logLevel.levelAsInt <= LogLevel.ERROR.levelAsInt;
        warnLevel = logLevel.levelAsInt <= LogLevel.WARN.levelAsInt;
        infoLevel = logLevel.levelAsInt <= LogLevel.INFO.levelAsInt;
        debugLevel = logLevel.levelAsInt <= LogLevel.DEBUG.levelAsInt;
        traceLevel = logLevel.levelAsInt <= LogLevel.TRACE.levelAsInt;
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static void trade(String message, Exception ex) {
        if (tradeLevel) {
            listener.log(LogLevel.TRADING, null, messagePrefix + message, ex);
        }
    }

    public static void trade(String category, String message, Exception ex) {
        if (tradeLevel) {
            listener.log(LogLevel.TRADING, category, messagePrefix + message, ex);
        }
    }

    public static void trade(String message) {
        if (tradeLevel) {
            listener.log(LogLevel.TRADING, null, messagePrefix + message, null);
        }
    }

    public static void trade(String category, String message) {
        if (tradeLevel) {
            listener.log(LogLevel.TRADING, category, messagePrefix + message, null);
        }
    }

    public static void error(String message, Throwable ex) {
        if (errorLevel) {
            listener.log(LogLevel.ERROR, null, messagePrefix + message, ex);
        }
    }

    public static void error(String category, String message, Exception ex) {
        if (errorLevel) {
            listener.log(LogLevel.ERROR, category, messagePrefix + message, ex);
        }
    }

    public static void error(String message) {
        if (errorLevel) {
            listener.log(LogLevel.ERROR, null, messagePrefix + message, null);
        }
    }

    public static void error(String category, String message) {
        if (errorLevel) {
            listener.log(LogLevel.ERROR, category, messagePrefix + message, null);
        }
    }

    public static void warn(String message, Exception ex) {
        if (warnLevel) {
            listener.log(LogLevel.WARN, null, messagePrefix + message, ex);
        }
    }

    public static void warn(String category, String message, Throwable ex) {
        if (warnLevel) {
            listener.log(LogLevel.WARN, category, messagePrefix + message, ex);
        }
    }

    public static void warn(String message) {
        if (warnLevel) {
            listener.log(LogLevel.WARN, null, messagePrefix + message, null);
        }
    }

    public static void warn(String category, String message) {
        if (warnLevel) {
            listener.log(LogLevel.WARN, category, messagePrefix + message, null);
        }
    }

    public static void info(String message, Exception ex) {
        if (infoLevel) {
            listener.log(LogLevel.INFO, null, messagePrefix + message, ex);
        }
    }

    public static void info(String category, String message, Exception ex) {
        if (infoLevel) {
            listener.log(LogLevel.INFO, category, messagePrefix + message, ex);
        }
    }

    public static void info(String message) {
        if (infoLevel) {
            listener.log(LogLevel.INFO, null, messagePrefix + message, null);
        }
    }

    public static void info(String category, String message) {
        if (infoLevel) {
            listener.log(LogLevel.INFO, category, messagePrefix + message, null);
        }
    }

    public static void debug(String message, Exception ex) {
        if (debugLevel) {
            listener.log(LogLevel.DEBUG, null, messagePrefix + message, ex);
        }
    }

    public static void debug(String category, String message, Exception ex) {
        if (debugLevel) {
            listener.log(LogLevel.DEBUG, category, messagePrefix + message, ex);
        }
    }

    public static void debug(String message) {
        if (debugLevel) {
            listener.log(LogLevel.DEBUG, null, messagePrefix + message, null);
        }
    }

    public static void debug(String category, String message) {
        if (debugLevel) {
            listener.log(LogLevel.DEBUG, category, messagePrefix + message, null);
        }
    }

    public static void trace(String message, Exception ex) {
        if (traceLevel) {
            listener.log(LogLevel.TRACE, null, messagePrefix + message, ex);
        }
    }

    public static void trace(String category, String message, Exception ex) {
        if (traceLevel) {
            listener.log(LogLevel.TRACE, category, messagePrefix + message, ex);
        }
    }

    public static void trace(String category, String message) {
        if (traceLevel) {
            listener.log(LogLevel.TRACE, category, messagePrefix + message, null);
        }
    }

    public static void trace(String message) {
        if (traceLevel) {
            listener.log(LogLevel.TRACE, null, messagePrefix + message, null);
        }
    }

    public static void perflog() {
        Log.perflogImpl("", 0L);
    }

    public static void perflog(String message) {
        Log.perflogImpl(messagePrefix + message, 0L);
    }

    public static void perflog(String message, long minDelayToLogNanos) {
        Log.perflogImpl(messagePrefix + message, minDelayToLogNanos);
    }

    private static void perflogImpl(String message, long minDelayToLogNanos) {
        long delay = Log.perflogReset();
        if (delay >= minDelayToLogNanos) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
            String fileName = stackTraceElement.getFileName();
            String className = stackTraceElement.getClassName();
            String methodName = stackTraceElement.getMethodName();
            int line = stackTraceElement.getLineNumber();
            Log.info("PERFLOG: " + className + "." + methodName + " [" + fileName + ":" + line + "] (+" + (double)(delay / 100000L) / 10.0 + "ms):" + message);
        }
    }

    public static long perflogReset() {
        long now = NanoClock.currentTimeNanos();
        long delay = now - lastPerflogEntryTime;
        lastPerflogEntryTime = now;
        return delay;
    }

    public static void warnFree(Object ... messages) {
        if (warnLevel) {
            StringBuilder builder = new StringBuilder(256);
            if (!messagePrefix.isEmpty()) {
                builder.append(messagePrefix);
            }
            for (int i = 0; i < messages.length; ++i) {
                builder.append(messages[i]).append(" ");
            }
            Log.warn(builder.toString());
        }
    }

    public static void infoFree(Object ... messages) {
        if (infoLevel) {
            StringBuilder builder = new StringBuilder(256);
            if (!messagePrefix.isEmpty()) {
                builder.append(messagePrefix);
            }
            for (int i = 0; i < messages.length; ++i) {
                builder.append(messages[i]).append(" ");
            }
            Log.info(builder.toString());
        }
    }

    public static void debugFree(Object ... messages) {
        if (debugLevel) {
            StringBuilder builder = new StringBuilder(256);
            if (!messagePrefix.isEmpty()) {
                builder.append(messagePrefix);
            }
            for (int i = 0; i < messages.length; ++i) {
                builder.append(messages[i]).append(" ");
            }
            Log.debug(builder.toString());
        }
    }

    public static void traceFree(Object ... messages) {
        if (traceLevel) {
            StringBuilder builder = new StringBuilder(256);
            if (!messagePrefix.isEmpty()) {
                builder.append(messagePrefix);
            }
            for (int i = 0; i < messages.length; ++i) {
                builder.append(messages[i]).append(" ");
            }
            Log.trace(builder.toString());
        }
    }

    public static void tradeFree(Object ... messages) {
        if (tradeLevel) {
            StringBuilder builder = new StringBuilder(256);
            if (!messagePrefix.isEmpty()) {
                builder.append(messagePrefix);
            }
            for (int i = 0; i < messages.length; ++i) {
                builder.append(messages[i]).append(" ");
            }
            Log.trade(builder.toString());
        }
    }

    @DontObfuscate
    public static interface LogListener {
        public void log(LogLevel var1, String var2, String var3, Throwable var4);
    }

    @DontObfuscate
    public static enum LogLevel {
        TRACE(1),
        DEBUG(2),
        INFO(3),
        WARN(4),
        ERROR(5),
        TRADING(6),
        NO_LOG(1000);

        public final int levelAsInt;

        private LogLevel(int levelAsInt) {
            this.levelAsInt = levelAsInt;
        }

        public static LogLevel fromInt(int levelAsInt) {
            return Arrays.stream(LogLevel.values()).filter(v -> v.levelAsInt == levelAsInt).findFirst().orElse(null);
        }

        public boolean allows(LogLevel level) {
            return this.levelAsInt <= level.levelAsInt;
        }
    }

    @DontObfuscate
    public static class SimpleConsoleLogger
    implements LogListener {
        @Override
        public void log(LogLevel level, String category, String message, Throwable ex) {
            System.err.print(new Date());
            if (category != null) {
                System.err.println(" [ " + category + " ]");
            }
            System.err.println("(" + Thread.currentThread().getName() + "|" + Thread.currentThread().getId() + ")");
            System.err.println(": " + message);
            if (ex != null) {
                ex.printStackTrace();
            }
        }
    }
}

