/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.AccountInfo;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.messages.TradingAccountsInfoMessage;

@Layer1ApiPublic
public class AccountListManager {
    private final Map<String, AccountInfo> accountsById = new HashMap<String, AccountInfo>();
    private final Map<AccountInfoMessageKey, AccountInfo> accountsByIdAndAlias = new HashMap<AccountInfoMessageKey, AccountInfo>();
    private final Map<String, String> accountIdByOrderId = new HashMap<String, String>();
    private final Map<String, AccountInfo> primaryAccountsByProvider = new HashMap<String, AccountInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AccountInfo> getAccounts() {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return Set.copyOf(this.accountsById.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getPrimaryAccountByProvider(String providerProgrammaticName) {
        Map<String, AccountInfo> map = this.primaryAccountsByProvider;
        synchronized (map) {
            return this.primaryAccountsByProvider.get(providerProgrammaticName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountInfo> getProviderOtherAccountsByAccountId(String accountId, boolean includePrimary) {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            AccountInfo accountInfo = this.accountsById.get(accountId);
            String providerProgrammaticName = accountInfo.providerProgrammaticName;
            return this.accountsById.values().stream().filter(info -> Objects.equals(info.providerProgrammaticName, providerProgrammaticName)).filter(info -> includePrimary || !info.isPrimary).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProvidersWithMultiAccounts() {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return this.accountsById.values().stream().map(info -> info.providerProgrammaticName).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getAccountById(String accountId) {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return this.accountsById.get(accountId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AccountInfo> getAccountsByAlias(String alias) {
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.entrySet().stream().filter(entry -> Objects.equals(((AccountInfoMessageKey)entry.getKey()).alias, alias)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAliasesByAccountId(String accountId) {
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.keySet().stream().filter(accountInfo -> accountInfo.accountId.equals(accountId)).map(accountInfo -> accountInfo.alias).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getAccountByOrderId(String orderId) {
        Map<String, String> map = this.accountIdByOrderId;
        synchronized (map) {
            String accountId = this.accountIdByOrderId.get(orderId);
            if (accountId == null) {
                return null;
            }
            Map<String, AccountInfo> map2 = this.accountsById;
            synchronized (map2) {
                return this.accountsById.get(accountId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isPrimaryAccountOrNull(String accountId) {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            if (accountId == null) {
                return true;
            }
            AccountInfo accountInfo = this.accountsById.get(accountId);
            if (accountInfo == null) {
                return null;
            }
            return accountInfo.isPrimary;
        }
    }

    public boolean isPrimaryAccount(String accountId) {
        Boolean isPrimary = this.isPrimaryAccountOrNull(accountId);
        return isPrimary == null || isPrimary != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isPrimaryAccountOrderOrNull(String orderId) {
        Map<String, String> map = this.accountIdByOrderId;
        synchronized (map) {
            String accountId = this.accountIdByOrderId.get(orderId);
            if (accountId == null) {
                return this.accountIdByOrderId.containsKey(orderId) ? Boolean.valueOf(true) : null;
            }
            return this.isPrimaryAccountOrNull(accountId);
        }
    }

    public boolean isPrimaryAccountOrder(String orderId) {
        Boolean isPrimary = this.isPrimaryAccountOrderOrNull(orderId);
        return isPrimary == null || isPrimary != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onUserMessage(Object message) {
        if (message instanceof TradingAccountsInfoMessage) {
            TradingAccountsInfoMessage accountMessage = (TradingAccountsInfoMessage)message;
            AccountInfoMessageKey key = new AccountInfoMessageKey(accountMessage.accountInfo.id, accountMessage.alias);
            Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
            synchronized (map) {
                boolean wasRemoved;
                if (accountMessage.isAdd) {
                    Map<String, AccountInfo> map2 = this.accountsById;
                    synchronized (map2) {
                        this.accountsById.put(accountMessage.accountInfo.id, accountMessage.accountInfo);
                    }
                    if (accountMessage.accountInfo.isPrimary) {
                        map2 = this.primaryAccountsByProvider;
                        synchronized (map2) {
                            this.primaryAccountsByProvider.put(accountMessage.accountInfo.providerProgrammaticName, accountMessage.accountInfo);
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 16, 4, 15] lbl29 : MonitorExitStatement: MONITOREXIT : var4_4
                    AccountInfo previousAccountInfo = this.accountsByIdAndAlias.put(key, accountMessage.accountInfo);
                    return previousAccountInfo == null || previousAccountInfo.isPrimary != accountMessage.accountInfo.isPrimary;
                }
                boolean bl = wasRemoved = this.accountsByIdAndAlias.remove(key) != null;
                if (accountMessage.alias == null) {
                    boolean otherAccountsWereRemoved = this.accountsByIdAndAlias.entrySet().removeIf(entry -> ((AccountInfoMessageKey)entry.getKey()).accountId.equals(accountMessage.accountInfo.id));
                    wasRemoved = otherAccountsWereRemoved || wasRemoved;
                }
                this.removeAccountIfNoAlias(accountMessage.accountInfo.id);
                Map<String, AccountInfo> map3 = this.primaryAccountsByProvider;
                synchronized (map3) {
                    AccountInfo accountInfo = this.primaryAccountsByProvider.get(accountMessage.accountInfo.providerProgrammaticName);
                    if (accountInfo != null && accountInfo.id.equals(accountMessage.accountInfo.id)) {
                        this.primaryAccountsByProvider.remove(accountMessage.accountInfo.providerProgrammaticName);
                    }
                }
                return wasRemoved;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TradingAccountsInfoMessage> generateMessagesFromAccountsList() {
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.entrySet().stream().map(entry -> new TradingAccountsInfoMessage(((AccountInfoMessageKey)entry.getKey()).alias, (AccountInfo)entry.getValue(), true)).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccountIfNoAlias(String accountId) {
        boolean hasAnyAlias = this.accountsByIdAndAlias.keySet().stream().anyMatch(accountInfo -> accountInfo.accountId.equals(accountId));
        if (!hasAnyAlias) {
            Map<String, AccountInfo> map = this.accountsById;
            synchronized (map) {
                this.accountsById.remove(accountId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        Map<String, String> map = this.accountIdByOrderId;
        synchronized (map) {
            this.accountIdByOrderId.put(orderInfoUpdate.orderId, orderInfoUpdate.accountId);
        }
    }

    private record AccountInfoMessageKey(String accountId, String alias) {
    }
}

