/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.concurrent.atomic.AtomicLong;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.NanoClock;
import velox.api.layer1.data.OrderUpdateParameters;

@Layer1ApiPublic
public class OrderCancelParameters
extends OrderUpdateParameters {
    private static final AtomicLong UNIQUE_BATCH_NUMBER_GENERATOR = new AtomicLong(NanoClock.currentTimeNanos());
    public final long batchId;
    public final boolean batchEnd;

    public OrderCancelParameters(String orderId) {
        this(orderId, true);
    }

    public OrderCancelParameters(String orderId, boolean batchEnd) {
        this(orderId, UNIQUE_BATCH_NUMBER_GENERATOR.incrementAndGet(), batchEnd);
    }

    public OrderCancelParameters(String orderId, long batchId, boolean batchEnd) {
        super(orderId);
        this.batchId = batchId;
        this.batchEnd = batchEnd;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "{super=" + super.toString() + ", batchId=" + this.batchId + ", batchEnd=" + this.batchEnd + "}";
    }
}

