/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.utils.localization.translatable;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.gui.utils.localization.translatable.TranslatableComponent;

@Layer1ApiPublic
public class TranslatableFormattedText
implements TranslatableComponent {
    private final String format;
    private final Object[] args;

    public TranslatableFormattedText(String format, Object ... args) {
        this.format = format;
        this.args = args;
    }

    @Override
    public String toLocalizedString(ULocale locale) {
        Object[] normalizedArgs = this.getNormalizedArgs(locale);
        MessageFormat messageFormat = new MessageFormat(this.format, locale);
        return messageFormat.format((Object)normalizedArgs);
    }

    private Object[] getNormalizedArgs(ULocale locale) {
        Object[] normalizedArgs = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            Object arg = this.args[i];
            normalizedArgs[i] = arg instanceof TranslatableComponent ? ((TranslatableComponent)arg).toLocalizedString(locale) : arg;
        }
        return normalizedArgs;
    }
}

