/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.Objects;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.AccountInfoBuilder;

@Layer1ApiPublic
public class AccountInfo {
    public final String id;
    public final String summary;
    public final String providerProgrammaticName;
    public final boolean isPrimary;

    @Deprecated
    public AccountInfo(String id) {
        this.id = id;
        this.summary = id;
        this.providerProgrammaticName = null;
        this.isPrimary = false;
    }

    AccountInfo(String id, String summary, String providerProgrammaticName, boolean isPrimary) {
        this.id = id;
        this.summary = summary;
        this.providerProgrammaticName = providerProgrammaticName;
        this.isPrimary = isPrimary;
    }

    public AccountInfoBuilder toBuilder() {
        AccountInfoBuilder builder = new AccountInfoBuilder(this.id, this.summary, this.isPrimary);
        builder.setProviderProgrammaticName(this.providerProgrammaticName);
        return builder;
    }

    public String toString() {
        return "{id=" + this.id + ", summary=" + this.summary + ", providerProgrammaticName=" + this.providerProgrammaticName + ", isPrimary=" + this.isPrimary + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountInfo)) {
            return false;
        }
        AccountInfo that = (AccountInfo)o;
        return this.isPrimary == that.isPrimary && Objects.equals(this.id, that.id) && Objects.equals(this.summary, that.summary) && Objects.equals(this.providerProgrammaticName, that.providerProgrammaticName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.summary, this.isPrimary, this.providerProgrammaticName);
    }
}

