/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public final class OrderStatus
extends Enum<OrderStatus> {
    public static final /* enum */ OrderStatus WORKING = new OrderStatus(0);
    public static final /* enum */ OrderStatus CANCELLED = new OrderStatus(1);
    public static final /* enum */ OrderStatus FILLED = new OrderStatus(2);
    @Deprecated
    public static final /* enum */ OrderStatus INACTIVE = new OrderStatus(4);
    public static final /* enum */ OrderStatus REJECTED = new OrderStatus(5);
    public static final /* enum */ OrderStatus PENDING_CANCEL = new OrderStatus(6);
    public static final /* enum */ OrderStatus PENDING_SUBMIT = new OrderStatus(7);
    public static final /* enum */ OrderStatus PENDING_MODIFY = new OrderStatus(8);
    public static final /* enum */ OrderStatus SUSPENDED = new OrderStatus(9);
    public static final /* enum */ OrderStatus DISCONNECTED = new OrderStatus(10);
    public final int code;
    private static final /* synthetic */ OrderStatus[] $VALUES;

    public static OrderStatus[] values() {
        return (OrderStatus[])$VALUES.clone();
    }

    public static OrderStatus valueOf(String name) {
        return Enum.valueOf(OrderStatus.class, name);
    }

    private OrderStatus(int code) {
        this.code = code;
    }

    public static OrderStatus valueOf(int code) {
        if (code == -1) {
            return null;
        }
        if (code == 3) {
            return PENDING_SUBMIT;
        }
        for (OrderStatus value : OrderStatus.values()) {
            if (value.code != code) continue;
            return value;
        }
        return null;
    }

    public static OrderStatus valueOfLoose(String name) {
        switch (name = name.toUpperCase()) {
            case "IN_CANCEL": 
            case "PENDINGCANCEL": {
                return PENDING_CANCEL;
            }
            case "IN_TRANSIT": 
            case "PRESUBMITTED": 
            case "PENDINGSUBMIT": 
            case "SENT": 
            case "ACCEPTED": {
                return PENDING_SUBMIT;
            }
            case "PENDINGMODIFY": 
            case "IN_MODIFY": {
                return PENDING_MODIFY;
            }
            case "COMPLETED": {
                return FILLED;
            }
            case "HELD": {
                return SUSPENDED;
            }
            case "EXPIRED": {
                return CANCELLED;
            }
        }
        try {
            return OrderStatus.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Unknown status " + name;
            return null;
        }
    }

    public boolean isActive() {
        return this == WORKING || this == PENDING_MODIFY || this == SUSPENDED;
    }

    private static /* synthetic */ OrderStatus[] $values() {
        return new OrderStatus[]{WORKING, CANCELLED, FILLED, INACTIVE, REJECTED, PENDING_CANCEL, PENDING_SUBMIT, PENDING_MODIFY, SUSPENDED, DISCONNECTED};
    }

    static {
        $VALUES = OrderStatus.$values();
    }
}

