/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public interface Layer1ApiTimeSource {
    public Layer1ApiProvider getTimeSource();

    public static Layer1ApiProvider getTimeSource(Layer1ApiProvider provider) {
        for (Class<?> cls = provider.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                boolean useShortcut;
                Method getCurrentTimeMethod = cls.getDeclaredMethod("getCurrentTime", new Class[0]);
                boolean bl = useShortcut = getCurrentTimeMethod.getAnnotation(Layer1TimeSourceShortcutAllowed.class) != null;
                if (useShortcut) {
                    return ((Layer1ApiTimeSource)((Object)provider)).getTimeSource();
                }
                return provider;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Time shortcut detection error for class " + provider.getClass().getName());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Layer1TimeSourceShortcutAllowed {
    }
}

