/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.utils.mbo;

import java.util.LinkedHashMap;
import java.util.Map;
import velox.api.layer1.Layer1ApiMboDataAdapter;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.layers.utils.mbo.Order;
import velox.api.layer1.layers.utils.mbo.OrderBookMbo;

@Layer1ApiPublic
public class OrderBookMboUnsorted {
    private final Map<String, Order> orders = new LinkedHashMap<String, Order>();

    public OrderBookMboUnsorted() {
    }

    public OrderBookMboUnsorted(OrderBookMboUnsorted other) {
        for (Order order : other.orders.values()) {
            this.orders.put(order.getOrderId(), new Order(order));
        }
    }

    public OrderBookMboUnsorted(OrderBookMbo other) {
        other.sendDataToListener(null, new Layer1ApiMboDataAdapter(){

            @Override
            public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
                OrderBookMboUnsorted.this.send(orderId, isBid, price, size);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataToListener(String alias, Layer1ApiMboDataListener listener) {
        Map<String, Order> map = this.orders;
        synchronized (map) {
            OrderBookMbo orderBookMbo = new OrderBookMbo();
            for (Order order : this.orders.values()) {
                orderBookMbo.send(order.getOrderId(), order.isBid(), order.getPrice(), order.getSize());
            }
            orderBookMbo.sendDataToListener(alias, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String orderId, boolean isBid, int price, int size) {
        Map<String, Order> map = this.orders;
        synchronized (map) {
            this.addOrder(orderId, new Order(orderId, isBid, price, size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String orderId, int price, int size) {
        Map<String, Order> map = this.orders;
        synchronized (map) {
            Order order = this.orders.get(orderId);
            if (order == null) {
                throw new IllegalArgumentException("Order " + orderId + " does not exist");
            }
            if (order.getPrice() == price && order.getSize() > size) {
                order.setSize(size);
            } else {
                this.removeOrder(orderId);
                order.setPrice(price);
                order.setSize(size);
                this.addOrder(orderId, order);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String orderId) {
        Map<String, Order> map = this.orders;
        synchronized (map) {
            this.removeOrder(orderId);
        }
    }

    private void addOrder(String orderId, Order order) {
        Order previousOrder = this.orders.put(orderId, order);
        if (previousOrder != null) {
            throw new IllegalArgumentException("Order " + order.getOrderId() + " already exists");
        }
    }

    private void removeOrder(String orderId) {
        Order order = this.orders.remove(orderId);
        if (order == null) {
            throw new IllegalArgumentException("Order " + orderId + " does not exist");
        }
    }

    public Order getOrder(String orderId) {
        return this.orders.get(orderId);
    }
}

