/*
 * Decompiled with CFR 0.152.
 */
package velox.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class BookmapScrollPane
extends JScrollPane {
    private static final int DEFAULT_VERTICAL_UNIT_INCREMENT = 12;
    private static final int DEFAULT_HORIZONTAL_UNIT_INCREMENT = 12;
    private boolean compressFromOutside = false;
    private boolean preventSpaceForScrollbarIfShorterThanMaximumHeight = false;
    private boolean shouldAddSpaceForScrollbar;

    public BookmapScrollPane() {
        this(null);
    }

    public BookmapScrollPane(JComponent view) {
        this(view, true);
    }

    public BookmapScrollPane(JComponent view, boolean shouldAddSpaceForScrollbar) {
        super(view);
        this.shouldAddSpaceForScrollbar = shouldAddSpaceForScrollbar;
        this.setDefaultScrollBarsUnitIncrement();
    }

    private void setDefaultScrollBarsUnitIncrement() {
        JScrollBar verticalScrollBar = this.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.getHorizontalScrollBar();
        verticalScrollBar.setUnitIncrement(12);
        horizontalScrollBar.setUnitIncrement(12);
    }

    public void setCompressFromOutside(boolean compressFromOutside) {
        this.compressFromOutside = compressFromOutside;
    }

    public void setPreventSpaceForScrollbarIfShorterThanMaximumHeight(boolean preventSpaceForScrollbarIfShorterThanMaximumHeight) {
        this.preventSpaceForScrollbarIfShorterThanMaximumHeight = preventSpaceForScrollbarIfShorterThanMaximumHeight;
    }

    @Override
    public Dimension preferredSize() {
        Dimension maximumSize;
        boolean shouldAddSpaceForScrollbar;
        Dimension preferredSize = super.preferredSize();
        Component comp = this.getViewport().getView();
        Dimension viewPref = comp.getPreferredSize();
        Dimension port = this.getViewport().getExtentSize();
        boolean bl = this.preventSpaceForScrollbarIfShorterThanMaximumHeight ? preferredSize.height > this.getMaximumSize().height : (shouldAddSpaceForScrollbar = port.height < viewPref.height);
        if (this.shouldAddSpaceForScrollbar && shouldAddSpaceForScrollbar) {
            preferredSize.width += this.getVerticalScrollBar().getPreferredSize().width;
        }
        if ((maximumSize = this.getMaximumSize()) != null && preferredSize != null) {
            preferredSize.width = Math.min(preferredSize.width, maximumSize.width);
            preferredSize.height = Math.min(preferredSize.height, maximumSize.height);
        }
        return preferredSize;
    }

    @Override
    public void doLayout() {
        if (this.compressFromOutside) {
            Component view = this.getViewport().getView();
            int maxWidth = this.getWidth() - this.getVerticalScrollBar().getPreferredSize().width;
            view.setPreferredSize(new Dimension(maxWidth, Integer.MAX_VALUE));
            view.doLayout();
            view.setPreferredSize(null);
            view.setPreferredSize(new Dimension(maxWidth, view.getPreferredSize().height));
        }
        super.doLayout();
    }
}

