/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.OrderUpdateParameters;

@Layer1ApiPublic
public class OrderMoveParameters
extends OrderUpdateParameters {
    public final double stopPrice;
    public final double limitPrice;

    public OrderMoveParameters(String orderId, double stopPrice, double limitPrice) {
        super(orderId);
        this.stopPrice = stopPrice;
        this.limitPrice = limitPrice;
    }

    private OrderMoveParameters(Builder builder) {
        super(builder);
        this.stopPrice = builder.stopPrice;
        this.limitPrice = builder.limitPrice;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "{super=" + super.toString() + ", stopPrice=" + this.stopPrice + ", limitPrice=" + this.limitPrice + "}";
    }

    @Layer1ApiPublic
    public static final class Builder
    extends OrderUpdateParameters.Builder<Builder> {
        private double stopPrice = Double.NaN;
        private double limitPrice = Double.NaN;

        public Builder(String orderId) {
            super(orderId);
        }

        private Builder(OrderMoveParameters parameters) {
            super(parameters);
            this.stopPrice = parameters.stopPrice;
            this.limitPrice = parameters.limitPrice;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setStopPrice(double stopPrice) {
            this.stopPrice = stopPrice;
            return this.self();
        }

        public double getStopPrice() {
            return this.stopPrice;
        }

        public Builder setLimitPrice(double limitPrice) {
            this.limitPrice = limitPrice;
            return this.self();
        }

        public double getLimitPrice() {
            return this.limitPrice;
        }

        @Override
        public OrderMoveParameters build() {
            return new OrderMoveParameters(this);
        }
    }
}

