/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.providers.helper;

import java.nio.charset.StandardCharsets;
import java.util.List;
import velox.api.layer1.Layer1ApiAdminListener;
import velox.api.layer1.Layer1GlobalConfig;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Log;
import velox.api.layer1.reading.UserDataUserMessage;

@Layer1ApiPublic
public class RawDataHelper {
    public static void sendRawData(String data, List<Layer1ApiAdminListener> adminListeners) {
        if (!Layer1GlobalConfig.recordRawPlatformData) {
            Log.error("Attempt to record raw platform data when it's not enabled");
            throw new IllegalStateException("Attempt to record raw platform data when it's not enabled");
        }
        UserDataUserMessage message = new UserDataUserMessage("velox.api.level1.RAW_PLATFORM_DATA", null, data.getBytes(StandardCharsets.UTF_8));
        for (Layer1ApiAdminListener listener : adminListeners) {
            listener.onUserMessage(message);
        }
    }

    public static boolean isRawDataRecordingEnabled() {
        return Layer1GlobalConfig.recordRawPlatformData;
    }
}

