/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.DefaultAndList;
import velox.api.layer1.data.HistoricalDataInfo;
import velox.api.layer1.data.InstrumentCoreInfo;
import velox.api.layer1.data.Layer1ApiProviderSupportedFeaturesBuilder;
import velox.api.layer1.data.LookupInfo;
import velox.api.layer1.data.OrderDuration;
import velox.api.layer1.data.OrderType;
import velox.api.layer1.data.SubscribeInfo;
import velox.api.layer1.data.SymbolMappingInfo;

@Layer1ApiPublic
public class Layer1ApiProviderSupportedFeatures {
    public final boolean trading;
    public final boolean multiAccountTrading;
    @Deprecated
    public List<String> tradingVia;
    @Deprecated
    public List<String> tradingFrom;
    public final boolean oco;
    public final boolean oso;
    public final boolean depth;
    public final boolean mbo;
    public final boolean trailingStopsAsIndependentOrders;
    public final boolean trailingStopsAsBracketChildren;
    public final boolean brackets;
    public final boolean bracketTiers;
    public final boolean convertOrderToMkt;
    public final List<OrderDuration> supportedLimitDurations;
    public final List<OrderDuration> supportedStopDurations;
    public final List<OrderType> supportedStopOrders;
    public final boolean negativeStopLimitOffset;
    public final boolean marketMode;
    public final boolean isBalanceSupported;
    public final boolean tradingStartKnown;
    public final List<SubscribeInfo> knownInstruments;
    public final boolean exchangeUsedForSubscription;
    public final boolean typeUsedForSubscription;
    public final Function<SubscribeInfo, DefaultAndList<Double>> pipsFunction;
    public final Function<SubscribeInfo, DefaultAndList<Double>> sizeMultiplierFunction;
    public final Function<SubscribeInfo, String> subscriptionInfoFunction;
    public final HistoricalDataInfo historicalDataInfo;
    public final LookupInfo lookupInfo;
    public final boolean isDelayed;
    public final Set<ClientSideFeature> clientSideFeatures;
    public final boolean isTradingSubscriptionSupported;
    public final Function<Set<InstrumentCoreInfo>, SymbolMappingInfo> symbolsMappingFunction;
    public final boolean receiveCrossTradingStatusMessage;
    public final boolean isHistoricalAggregationDisabled;

    Layer1ApiProviderSupportedFeatures(boolean trading, boolean multiAccountTrading, List<String> tradingVia, List<String> tradingFrom, boolean oco, boolean oso, boolean depth, boolean mbo, boolean trailingStopsAsIndependentOrders, boolean trailingStopsAsBracketChildren, boolean brackets, boolean bracketTiers, boolean convertOrderToMkt, boolean marketMode, List<OrderDuration> supportedLimitDurations, List<OrderDuration> supportedStopDurations, List<OrderType> supportedStopOrders, boolean negativeStopLimitOffset, boolean isBalanceSupported, boolean tradingStartKnown, List<SubscribeInfo> knownInstruments, boolean exchangeUsedForSubscription, boolean typeUsedForSubscription, Function<SubscribeInfo, DefaultAndList<Double>> pipsFunction, Function<SubscribeInfo, DefaultAndList<Double>> sizeMultiplierFunction, Function<SubscribeInfo, String> subscriptionInfoFunction, HistoricalDataInfo historicalDataInfo, LookupInfo lookupInfo, boolean isDelayed, Set<ClientSideFeature> clientSideFeatures, boolean isTradingSubscriptionSupported, Function<Set<InstrumentCoreInfo>, SymbolMappingInfo> symbolsMappingFunction, boolean receiveCrossTradingStatusMessage, boolean isHistoricalAggregationDisabled) {
        this.trading = trading;
        this.multiAccountTrading = multiAccountTrading;
        this.tradingVia = Collections.unmodifiableList(new ArrayList<String>(tradingVia));
        this.tradingFrom = Collections.unmodifiableList(new ArrayList<String>(tradingFrom));
        this.oco = oco;
        this.oso = oso;
        this.depth = depth;
        this.mbo = mbo;
        this.trailingStopsAsIndependentOrders = trailingStopsAsIndependentOrders;
        this.trailingStopsAsBracketChildren = trailingStopsAsBracketChildren;
        this.brackets = brackets;
        this.bracketTiers = bracketTiers;
        this.convertOrderToMkt = convertOrderToMkt;
        this.marketMode = marketMode;
        this.supportedLimitDurations = Collections.unmodifiableList(new ArrayList<OrderDuration>(supportedLimitDurations));
        this.supportedStopDurations = Collections.unmodifiableList(new ArrayList<OrderDuration>(supportedStopDurations));
        this.supportedStopOrders = Collections.unmodifiableList(new ArrayList<OrderType>(supportedStopOrders));
        this.negativeStopLimitOffset = negativeStopLimitOffset;
        this.isBalanceSupported = isBalanceSupported;
        this.tradingStartKnown = tradingStartKnown;
        this.knownInstruments = Collections.unmodifiableList(new ArrayList<SubscribeInfo>(knownInstruments));
        this.exchangeUsedForSubscription = exchangeUsedForSubscription;
        this.typeUsedForSubscription = typeUsedForSubscription;
        this.pipsFunction = pipsFunction;
        this.sizeMultiplierFunction = sizeMultiplierFunction;
        this.subscriptionInfoFunction = subscriptionInfoFunction;
        this.historicalDataInfo = historicalDataInfo;
        this.lookupInfo = lookupInfo;
        this.isDelayed = isDelayed;
        this.clientSideFeatures = Collections.unmodifiableSet(new HashSet<ClientSideFeature>(clientSideFeatures));
        this.isTradingSubscriptionSupported = isTradingSubscriptionSupported;
        this.symbolsMappingFunction = symbolsMappingFunction;
        this.receiveCrossTradingStatusMessage = receiveCrossTradingStatusMessage;
        this.isHistoricalAggregationDisabled = isHistoricalAggregationDisabled;
    }

    public Layer1ApiProviderSupportedFeatures getCopyWithAppliedTradingParams(Layer1ApiProviderSupportedFeatures other) {
        Layer1ApiProviderSupportedFeaturesBuilder builder = other.toBuilder();
        builder.setMarketMode(this.marketMode);
        builder.setDelayed(this.isDelayed);
        builder.setOso(this.oso);
        builder.setOco(this.oco);
        builder.setBrackets(this.brackets);
        builder.setTrailingStopsAsIndependentOrders(this.trailingStopsAsIndependentOrders);
        builder.setTrailingStopsAsBracketChildren(this.trailingStopsAsBracketChildren);
        builder.setConvertOrderToMkt(this.convertOrderToMkt);
        builder.setClientSideFeatures(this.clientSideFeatures);
        builder.setNegativeStopLimitOffset(this.negativeStopLimitOffset);
        builder.setTrading(this.trading);
        builder.setSupportedLimitDurations(this.supportedLimitDurations);
        builder.setSupportedStopDurations(this.supportedStopDurations);
        builder.setSupportedStopOrders(this.supportedStopOrders);
        builder.setTradingSubscriptionSupported(this.isTradingSubscriptionSupported);
        return builder.build();
    }

    public Layer1ApiProviderSupportedFeaturesBuilder toBuilder() {
        Layer1ApiProviderSupportedFeaturesBuilder builder = new Layer1ApiProviderSupportedFeaturesBuilder();
        builder.setTrading(this.trading);
        builder.setMultiAccountTrading(this.multiAccountTrading);
        builder.setTradingVia(this.tradingVia);
        builder.setTradingFrom(this.tradingFrom);
        builder.setOco(this.oco);
        builder.setOso(this.oso);
        builder.setDepth(this.depth);
        builder.setMbo(this.mbo);
        builder.setTrailingStopsAsIndependentOrders(this.trailingStopsAsIndependentOrders);
        builder.setTrailingStopsAsBracketChildren(this.trailingStopsAsBracketChildren);
        builder.setBrackets(this.brackets);
        builder.setBracketTiers(this.bracketTiers);
        builder.setConvertOrderToMkt(this.convertOrderToMkt);
        builder.setMarketMode(this.marketMode);
        builder.setSupportedLimitDurations(this.supportedLimitDurations);
        builder.setSupportedStopDurations(this.supportedStopDurations);
        builder.setSupportedStopOrders(this.supportedStopOrders);
        builder.setNegativeStopLimitOffset(this.negativeStopLimitOffset);
        builder.setBalanceSupported(this.isBalanceSupported);
        builder.setTradingStartKnown(this.tradingStartKnown);
        builder.setKnownInstruments(this.knownInstruments);
        builder.setExchangeUsedForSubscription(this.exchangeUsedForSubscription);
        builder.setTypeUsedForSubscription(this.typeUsedForSubscription);
        builder.setPipsFunction(this.pipsFunction);
        builder.setSizeMultiplierFunction(this.sizeMultiplierFunction);
        builder.setSubscriptionInfoFunction(this.subscriptionInfoFunction);
        builder.setHistoricalDataInfo(this.historicalDataInfo);
        builder.setLookupInfo(this.lookupInfo);
        builder.setDelayed(this.isDelayed);
        builder.setClientSideFeatures(this.clientSideFeatures);
        builder.setTradingSubscriptionSupported(this.isTradingSubscriptionSupported);
        builder.setSymbolsMappingFunction(this.symbolsMappingFunction);
        builder.setReceiveCrossTradingStatusMessage(this.receiveCrossTradingStatusMessage);
        builder.setHistoricalAggregationDisabled(this.isHistoricalAggregationDisabled);
        return builder;
    }

    public String toString() {
        return "Layer1ApiProviderSupportedFeatures [trading=" + this.trading + ", multiAccountTrading=" + this.multiAccountTrading + ", oco=" + this.oco + ", oso=" + this.oso + ", trailingStopsAsIndependentOrders=" + this.trailingStopsAsIndependentOrders + ", trailingStopsAsBracketChildren=" + this.trailingStopsAsBracketChildren + ", brackets=" + this.brackets + ", convertOrderToMkt=" + this.convertOrderToMkt + ", supportedLimitDurations=" + String.valueOf(this.supportedLimitDurations) + ", supportedStopDurations=" + String.valueOf(this.supportedStopDurations) + ", supportedStopOrders=" + String.valueOf(this.supportedStopOrders) + ", negativeStopLimitOffset=" + this.negativeStopLimitOffset + ", marketMode=" + this.marketMode + ", isTradingSubscriptionSupported=" + this.isTradingSubscriptionSupported + ", receiveCrossTradingStatusMessage=" + this.receiveCrossTradingStatusMessage + ", disableHistoricalAggregation=" + this.isHistoricalAggregationDisabled + "]";
    }

    @Layer1ApiPublic
    public static enum ClientSideFeature {
        BRACKETS,
        OCO,
        OSO,
        TRAILING_STOPS_INDEPENDENT,
        TRAILING_STOPS_AS_BRACKET_CHILDREN;

    }
}

