/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.util.function.BiConsumer;
import java.util.function.Function;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class Layer1GlobalStorage {
    private static Function<String, String> valuesGetter;
    private static BiConsumer<String, String> valuesSetter;

    public static void setStorageCallbacks(Function<String, String> valuesGetter, BiConsumer<String, String> valuesSetter) {
        if (Layer1GlobalStorage.valuesGetter != null) {
            throw new IllegalStateException("valuesGetter callback already set");
        }
        Layer1GlobalStorage.valuesGetter = valuesGetter;
        if (Layer1GlobalStorage.valuesSetter != null) {
            throw new IllegalStateException("valuesSetter callback already set");
        }
        Layer1GlobalStorage.valuesSetter = valuesSetter;
    }

    public static void set(String key, String value) {
        valuesSetter.accept(key, value);
    }

    public static String get(String key) {
        return valuesGetter.apply(key);
    }
}

