/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common;

import java.util.concurrent.TimeUnit;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Log;

@Layer1ApiPublic
public class NanoClock {
    private static final long ADJUSTMENT_STEP_MS = 50L;
    private static final int ADJUSTMENT_BACK_SAFETY_INTERVAL = 5;
    private static final long RAPID_FORWARD_ADJUSTMENT_THRESHOLD_MS = TimeUnit.MINUTES.toMillis(1L);
    private static long lastNanoTime = 0L;
    private static boolean needToLogTimeMovedBackward = true;
    private static long nanoOffset;
    private static Long forceTime;
    private static long stopUntil;
    private static long stopValue;
    private static final Object MONITOR;

    private static long getSystemNanoTime() {
        long nanoTime = System.nanoTime();
        if (nanoTime < lastNanoTime) {
            if (needToLogTimeMovedBackward) {
                needToLogTimeMovedBackward = false;
                Log.warn("NanoClock", "Time moved backward: lastTime: " + lastNanoTime + "; currentTime: " + nanoTime);
            }
            return lastNanoTime;
        }
        lastNanoTime = nanoTime;
        return nanoTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long currentTimeNanos() {
        Object object = MONITOR;
        synchronized (object) {
            if (forceTime != null) {
                return forceTime;
            }
            long nanoTime = NanoClock.getSystemNanoTime();
            if (stopUntil > nanoTime) {
                return stopValue;
            }
            return nanoOffset + nanoTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setForceTime(long nanoOffset) {
        Object object = MONITOR;
        synchronized (object) {
            forceTime = nanoOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getForceTime() {
        Object object = MONITOR;
        synchronized (object) {
            if (forceTime == null) {
                throw new IllegalStateException("Force time is not set");
            }
            return forceTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        forceTime = null;
        stopUntil = 0L;
        stopValue = 0L;
        Object object = MONITOR = new Object();
        synchronized (object) {
            nanoOffset = System.currentTimeMillis() * 1000000L - NanoClock.getSystemNanoTime();
        }
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        Object object = MONITOR;
                        synchronized (object) {
                            long msOffset = System.currentTimeMillis() - NanoClock.currentTimeNanos() / 1000000L;
                            if (msOffset > 50L) {
                                if (msOffset > RAPID_FORWARD_ADJUSTMENT_THRESHOLD_MS) {
                                    nanoOffset += msOffset * 1000000L;
                                    Log.debug("moving NanoClock forward rapidly to match current time");
                                } else {
                                    nanoOffset += 50000000L;
                                    Log.debug("moving NanoClock 50ms forward");
                                }
                                stopUntil = 0L;
                            } else if (msOffset < -50L) {
                                stopValue = NanoClock.currentTimeNanos();
                                stopUntil = NanoClock.getSystemNanoTime() + 55000000L;
                                nanoOffset -= 50000000L;
                                Log.debug("moving NanoClock 50ms back");
                            }
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Log.error(ex.toString());
                    continue;
                }
                break;
            }
        }, "NanoClock synchronization");
        thread.setDaemon(true);
        thread.start();
    }
}

