/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.OrderUpdateParameters;

@Layer1ApiPublic
public class OrderResizeParameters
extends OrderUpdateParameters {
    public final int size;

    public OrderResizeParameters(String orderId, int size) {
        super(orderId);
        this.size = size;
    }

    private OrderResizeParameters(Builder builder) {
        super(builder);
        this.size = builder.size;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "{super=" + super.toString() + ", size=" + this.size + "}";
    }

    @Layer1ApiPublic
    public static final class Builder
    extends OrderUpdateParameters.Builder<Builder> {
        private int size;

        public Builder(String orderId, int size) {
            super(orderId);
            this.size = size;
        }

        private Builder(OrderResizeParameters parameters) {
            super(parameters);
            this.size = parameters.size;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setSize(int size) {
            this.size = size;
            return this.self();
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public OrderResizeParameters build() {
            return new OrderResizeParameters(this);
        }
    }
}

