/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.RunModeHelper;
import velox.api.layer1.data.AccountInfo;
import velox.api.layer1.data.AccountType;

@Layer1ApiPublic
public class AccountInfoBuilder {
    private String id;
    private String summary;
    private String shortName;
    private String providerProgrammaticName;
    private boolean isPrimary;
    private AccountType accountType;
    private boolean isHidden;

    public AccountInfoBuilder(String id, String summary) {
        this.id = id;
        this.summary = summary;
        this.accountType = AccountType.UNKNOWN;
    }

    @Deprecated
    public AccountInfoBuilder(String id, String summary, boolean isPrimary) {
        this.id = id;
        this.summary = summary;
        this.isPrimary = isPrimary;
        this.accountType = AccountType.UNKNOWN;
    }

    public AccountInfo build() {
        String finalShortName = this.shortName;
        if (finalShortName == null && this.providerProgrammaticName != null && this.providerProgrammaticName.equals("EXT:velox.api.layer0.adapters.nelogica.NelogicaProvider") && RunModeHelper.isRealTrading().booleanValue() && this.summary != null) {
            finalShortName = this.summary.length() > 5 ? this.summary.substring(this.summary.length() - 5) : this.summary;
        }
        return new AccountInfo(this.id, this.summary, finalShortName, this.providerProgrammaticName, this.isPrimary, this.accountType, this.isHidden);
    }

    public String getId() {
        return this.id;
    }

    public AccountInfoBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public AccountInfoBuilder setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getShortName() {
        return this.shortName;
    }

    public AccountInfoBuilder setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public AccountInfoBuilder setPrimary(boolean primary) {
        this.isPrimary = primary;
        return this;
    }

    public String getProviderProgrammaticName() {
        return this.providerProgrammaticName;
    }

    public AccountInfoBuilder setProviderProgrammaticName(String providerProgrammaticName) {
        this.providerProgrammaticName = providerProgrammaticName;
        return this;
    }

    public boolean isSimulated() {
        return this.accountType == AccountType.SIMULATED;
    }

    public AccountInfoBuilder setSimulated(boolean simulated) {
        this.accountType = simulated ? AccountType.SIMULATED : AccountType.LIVE;
        return this;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public AccountInfoBuilder setAccountType(AccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public AccountInfoBuilder setHidden(boolean hidden) {
        this.isHidden = hidden;
        return this;
    }
}

