/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers;

import java.util.concurrent.atomic.AtomicBoolean;
import velox.api.layer1.Layer1ApiAdminListener;
import velox.api.layer1.Layer1ApiBasicListenable;
import velox.api.layer1.Layer1ApiDataListener;
import velox.api.layer1.Layer1ApiInstrumentListener;
import velox.api.layer1.Layer1ApiListener;
import velox.api.layer1.Layer1ApiMboDataListener;
import velox.api.layer1.Layer1ApiTradingListener;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.DisconnectionReason;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.LoginFailedReason;
import velox.api.layer1.data.MarketMode;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.SystemTextMessageType;
import velox.api.layer1.data.TradeInfo;
import velox.api.layer1.messages.SelectAccountMessage;

@Layer1ApiPublic
public class Layer1ApiUpstreamRelay
extends Layer1ApiBasicListenable
implements Layer1ApiListener {
    protected AtomicBoolean closed = new AtomicBoolean();

    @Override
    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
        if (this.theOnlyInstrumentListener != null) {
            if (!this.closed.get()) {
                this.theOnlyInstrumentListener.onInstrumentAdded(alias, instrumentInfo);
            }
        } else {
            for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
                if (this.closed.get()) continue;
                listener.onInstrumentAdded(alias, instrumentInfo);
            }
        }
    }

    @Override
    public void onInstrumentRemoved(String alias) {
        if (this.theOnlyInstrumentListener != null) {
            if (!this.closed.get()) {
                this.theOnlyInstrumentListener.onInstrumentRemoved(alias);
            }
        } else {
            for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
                if (this.closed.get()) continue;
                listener.onInstrumentRemoved(alias);
            }
        }
    }

    @Override
    public void onInstrumentNotFound(String symbol, String exchange, String type) {
        if (this.theOnlyInstrumentListener != null) {
            if (!this.closed.get()) {
                this.theOnlyInstrumentListener.onInstrumentNotFound(symbol, exchange, type);
            }
        } else {
            for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
                if (this.closed.get()) continue;
                listener.onInstrumentNotFound(symbol, exchange, type);
            }
        }
    }

    @Override
    public void onInstrumentAlreadySubscribed(String symbol, String exchange, String type) {
        if (this.theOnlyInstrumentListener != null) {
            if (!this.closed.get()) {
                this.theOnlyInstrumentListener.onInstrumentAlreadySubscribed(symbol, exchange, type);
            }
        } else {
            for (Layer1ApiInstrumentListener listener : this.instrumentListeners) {
                if (this.closed.get()) continue;
                listener.onInstrumentAlreadySubscribed(symbol, exchange, type);
            }
        }
    }

    @Override
    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
        if (this.theOnlyDataListener != null) {
            if (!this.closed.get()) {
                this.theOnlyDataListener.onTrade(alias, price, size, tradeInfo);
            }
        } else {
            for (Layer1ApiDataListener listener : this.dataListeners) {
                if (this.closed.get()) continue;
                listener.onTrade(alias, price, size, tradeInfo);
            }
        }
    }

    @Override
    public void onDepth(String alias, boolean isBid, int price, int size) {
        if (this.theOnlyDataListener != null) {
            if (!this.closed.get()) {
                this.theOnlyDataListener.onDepth(alias, isBid, price, size);
            }
        } else {
            for (Layer1ApiDataListener listener : this.dataListeners) {
                if (this.closed.get()) continue;
                listener.onDepth(alias, isBid, price, size);
            }
        }
    }

    @Override
    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
        if (this.theOnlyMboDataListener != null) {
            if (!this.closed.get()) {
                this.theOnlyMboDataListener.onMboSend(alias, orderId, isBid, price, size);
            }
        } else {
            for (Layer1ApiMboDataListener listener : this.mboDataListeners) {
                if (this.closed.get()) continue;
                listener.onMboSend(alias, orderId, isBid, price, size);
            }
        }
    }

    @Override
    public void onMboReplace(String alias, String orderId, int price, int size) {
        if (this.theOnlyMboDataListener != null) {
            if (!this.closed.get()) {
                this.theOnlyMboDataListener.onMboReplace(alias, orderId, price, size);
            }
        } else {
            for (Layer1ApiMboDataListener listener : this.mboDataListeners) {
                if (this.closed.get()) continue;
                listener.onMboReplace(alias, orderId, price, size);
            }
        }
    }

    @Override
    public void onMboCancel(String alias, String orderId) {
        if (this.theOnlyMboDataListener != null) {
            if (!this.closed.get()) {
                this.theOnlyMboDataListener.onMboCancel(alias, orderId);
            }
        } else {
            for (Layer1ApiMboDataListener listener : this.mboDataListeners) {
                if (this.closed.get()) continue;
                listener.onMboCancel(alias, orderId);
            }
        }
    }

    @Override
    public void onMarketMode(String alias, MarketMode marketMode) {
        if (this.theOnlyDataListener != null) {
            if (!this.closed.get()) {
                this.theOnlyDataListener.onMarketMode(alias, marketMode);
            }
        } else {
            for (Layer1ApiDataListener listener : this.dataListeners) {
                if (this.closed.get()) continue;
                listener.onMarketMode(alias, marketMode);
            }
        }
    }

    @Override
    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        if (this.theOnlyTradingListener != null) {
            if (!this.closed.get()) {
                this.theOnlyTradingListener.onOrderUpdated(orderInfoUpdate);
            }
        } else {
            for (Layer1ApiTradingListener listener : this.tradingListeners) {
                if (this.closed.get()) continue;
                listener.onOrderUpdated(orderInfoUpdate);
            }
        }
    }

    @Override
    public void onOrderExecuted(ExecutionInfo executionInfo) {
        if (this.theOnlyTradingListener != null) {
            if (!this.closed.get()) {
                this.theOnlyTradingListener.onOrderExecuted(executionInfo);
            }
        } else {
            for (Layer1ApiTradingListener listener : this.tradingListeners) {
                if (this.closed.get()) continue;
                listener.onOrderExecuted(executionInfo);
            }
        }
    }

    @Override
    public void onStatus(StatusInfo statusInfo) {
        if (this.theOnlyTradingListener != null) {
            if (!this.closed.get()) {
                this.theOnlyTradingListener.onStatus(statusInfo);
            }
        } else {
            for (Layer1ApiTradingListener listener : this.tradingListeners) {
                if (this.closed.get()) continue;
                listener.onStatus(statusInfo);
            }
        }
    }

    @Override
    public void onBalance(BalanceInfo balanceInfo) {
        if (this.theOnlyTradingListener != null) {
            if (!this.closed.get()) {
                this.theOnlyTradingListener.onBalance(balanceInfo);
            }
        } else {
            for (Layer1ApiTradingListener listener : this.tradingListeners) {
                if (this.closed.get()) continue;
                listener.onBalance(balanceInfo);
            }
        }
    }

    @Override
    public void onLoginFailed(LoginFailedReason reason, String message) {
        if (this.theOnlyAdminListener != null) {
            if (!this.closed.get()) {
                this.theOnlyAdminListener.onLoginFailed(reason, message);
            }
        } else {
            for (Layer1ApiAdminListener listener : this.adminListeners) {
                if (this.closed.get()) continue;
                listener.onLoginFailed(reason, message);
            }
        }
    }

    @Override
    public void onLoginSuccessful() {
        if (this.theOnlyAdminListener != null) {
            if (!this.closed.get()) {
                this.theOnlyAdminListener.onLoginSuccessful();
            }
        } else {
            for (Layer1ApiAdminListener listener : this.adminListeners) {
                if (this.closed.get()) continue;
                listener.onLoginSuccessful();
            }
        }
    }

    @Override
    public void onConnectionLost(DisconnectionReason reason, String message) {
        if (this.theOnlyAdminListener != null) {
            if (!this.closed.get()) {
                this.theOnlyAdminListener.onConnectionLost(reason, message);
            }
        } else {
            for (Layer1ApiAdminListener listener : this.adminListeners) {
                if (this.closed.get()) continue;
                listener.onConnectionLost(reason, message);
            }
        }
    }

    @Override
    public void onConnectionRestored() {
        if (this.theOnlyAdminListener != null) {
            if (!this.closed.get()) {
                this.theOnlyAdminListener.onConnectionRestored();
            }
        } else {
            for (Layer1ApiAdminListener listener : this.adminListeners) {
                if (this.closed.get()) continue;
                listener.onConnectionRestored();
            }
        }
    }

    @Override
    public void onSystemTextMessage(String message, SystemTextMessageType messageType) {
        if (this.theOnlyAdminListener != null) {
            if (!this.closed.get()) {
                this.theOnlyAdminListener.onSystemTextMessage(message, messageType);
            }
        } else {
            for (Layer1ApiAdminListener listener : this.adminListeners) {
                if (this.closed.get()) continue;
                listener.onSystemTextMessage(message, messageType);
            }
        }
    }

    @Override
    public void onUserMessage(Object data) {
        boolean isClosed = this.closed.get();
        if (isClosed && data.getClass() == SelectAccountMessage.class) {
            ((SelectAccountMessage)data).set(0);
        }
        if (this.theOnlyAdminListener != null) {
            if (!isClosed) {
                this.theOnlyAdminListener.onUserMessage(data);
            }
        } else {
            for (Layer1ApiAdminListener listener : this.adminListeners) {
                if (isClosed) continue;
                listener.onUserMessage(data);
            }
        }
    }

    public void close() {
        this.closed.set(true);
    }
}

