/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.utils.localization;

import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.ListCellRenderer;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.gui.utils.localization.BookmapLocale;
import velox.gui.utils.localization.NumberFormatStyle;
import velox.gui.utils.localization.translatable.TranslatableComponent;

@Layer1ApiPublic
public class LocalizationUtils {
    public static final String FULL_DATE_SKELETON = "HmsEMMMdyz";

    public static Collator getCollator() {
        return Collator.getInstance((ULocale)BookmapLocale.getCurrentULocale());
    }

    public static List<String> sortAlphabetically(List<String> strings) {
        Collator collator = LocalizationUtils.getCollator();
        return strings.stream().sorted(collator).collect(Collectors.toList());
    }

    public static MessageFormat getMessageFormat(String pattern) {
        return new MessageFormat(pattern, BookmapLocale.getCurrentULocale());
    }

    public static Currency getCurrency() {
        return Currency.getInstance((ULocale)BookmapLocale.getCurrentULocale());
    }

    public static Currency getCurrency(String theIsoCode) {
        return Currency.getInstance((String)theIsoCode);
    }

    public static NumberFormat getDefaultNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance((ULocale)ULocale.US);
        nf.setGroupingUsed(false);
        nf.setParseStrict(true);
        return nf;
    }

    public static NumberFormat getNumberFormat() {
        return NumberFormat.getInstance((ULocale)BookmapLocale.getCurrentULocale());
    }

    public static DateFormat getDateFormatForSceleton(String skeleton) {
        return DateFormat.getInstanceForSkeleton((String)skeleton, (ULocale)BookmapLocale.getCurrentULocale());
    }

    public static NumberFormat getNumberFormat(NumberFormatStyle numberFormat) {
        return NumberFormat.getInstance((ULocale)BookmapLocale.getCurrentULocale(), (int)numberFormat.index);
    }

    public static LocalizedNumberFormatter getNumberFormatter() {
        return NumberFormatter.withLocale((ULocale)BookmapLocale.getCurrentULocale());
    }

    public static LocalizedNumberFormatter getDefaultNumberFormatter() {
        return NumberFormatter.withLocale((ULocale)BookmapLocale.getDefaultULocale());
    }

    public static String format(long number) {
        return LocalizationUtils.getNumberFormatter().format(number).toString();
    }

    public static String format(double number) {
        return LocalizationUtils.getNumberFormatter().format(number).toString();
    }

    public static String format(double number, int precision) {
        return ((LocalizedNumberFormatter)LocalizationUtils.getNumberFormatter().precision((Precision)Precision.maxFraction((int)precision))).format(number).toString();
    }

    public static String format(double number, Currency currency) {
        return LocalizationUtils.getNumberFormat().format(new CurrencyAmount(number, currency));
    }

    public static Number parseNumber(String text) {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NumberFormat.getInstance((ULocale)BookmapLocale.getCurrentULocale()).parse(text, parsePosition);
        if (parsePosition.getIndex() != text.length()) {
            throw new NumberFormatException(String.format("Error while parsing number at index %d, input string: %s", parsePosition.getErrorIndex() != -1 ? parsePosition.getErrorIndex() : parsePosition.getIndex(), text));
        }
        return number;
    }

    public static double parseDouble(String text) {
        return LocalizationUtils.parseNumber(text).doubleValue();
    }

    public static int parseInteger(String text) {
        return LocalizationUtils.parseNumber(text).intValue();
    }

    public static double parseLong(String text) {
        return LocalizationUtils.parseNumber(text).longValue();
    }

    public static Map<String, Object> mapOf(Object ... input) {
        if (input.length % 2 == 1) {
            throw new IllegalArgumentException("Number of input arguments is odd");
        }
        Map.Entry[] entries = new Map.Entry[input.length / 2];
        for (int i = 0; i < entries.length; ++i) {
            String key = (String)input[i * 2];
            Object value = input[i * 2 + 1];
            if (value == null) {
                value = "null";
            }
            entries[i] = new AbstractMap.SimpleEntry<String, Object>(key, value);
        }
        return Map.ofEntries(entries);
    }

    public static Map<String, Object> mapOf(Map<String, Object> map) {
        Map.Entry[] entries = new Map.Entry[map.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                value = "null";
            }
            entries[i] = new AbstractMap.SimpleEntry<String, Object>(key, value);
            ++i;
        }
        return Map.ofEntries(entries);
    }

    public static <E> ListCellRenderer<E> localizeListCellRenderer(ListCellRenderer<? super E> renderer, Function<E, String> localizedStringSupplier) {
        ListCellRenderer finalRenderer = renderer;
        return (list, value, index, isSelected, cellHasFocus) -> finalRenderer.getListCellRendererComponent(list, (Object)localizedStringSupplier.apply(value), index, isSelected, cellHasFocus);
    }

    public static <E extends TranslatableComponent> ListCellRenderer<E> localizeListCellRenderer(ListCellRenderer<? super E> renderer) {
        ListCellRenderer finalRenderer = renderer;
        return (list, value, index, isSelected, cellHasFocus) -> finalRenderer.getListCellRendererComponent(list, value.toLocalizedString(), index, isSelected, cellHasFocus);
    }
}

