/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common.helper;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.AccountInfo;
import velox.api.layer1.data.OrderInfo;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.messages.SelectedAccountChangedMessage;
import velox.api.layer1.messages.TradingAccountsInfoMessage;

@Layer1ApiPublic
public class AccountListManager {
    private final Map<String, AccountInfo> accountsById = new HashMap<String, AccountInfo>();
    private final Map<AccountInfoMessageKey, AccountInfo> accountsByIdAndAlias = new HashMap<AccountInfoMessageKey, AccountInfo>();
    private final Map<String, OrderInfo> ordersByOrderId = new HashMap<String, OrderInfo>();
    private final Map<String, String> selectedAccountIdByAlias = new HashMap<String, String>();
    private final Map<String, Set<String>> aliasesBySelectedAccountId = new HashMap<String, Set<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AccountInfo> getAccounts() {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return Set.copyOf(this.accountsById.values());
        }
    }

    @Deprecated
    public AccountInfo getPrimaryAccountByProvider(String providerProgrammaticName) {
        return null;
    }

    public boolean isAccountSelectedForAlias(String accountId, String alias) {
        Preconditions.checkNotNull((Object)alias, (Object)"alias cannot be null");
        Preconditions.checkNotNull((Object)accountId, (Object)"accountId cannot be null");
        return this.getSelectedAccountIdForAlias(alias).map(selectedAccountId -> Objects.equals(selectedAccountId, accountId)).orElse(false);
    }

    public boolean isAnyAccountSelectedForAlias(String alias) {
        return this.getSelectedAccountIdForAlias(alias).isPresent();
    }

    public Optional<AccountInfo> getSelectedAccountForAlias(String alias) {
        return this.getSelectedAccountIdForAlias(alias).map(this::getAccountById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> getSelectedAccountIdForAlias(String alias) {
        String accountId;
        Map<String, String> map = this.selectedAccountIdByAlias;
        synchronized (map) {
            accountId = this.selectedAccountIdByAlias.get(alias);
        }
        return Optional.ofNullable(accountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountInfo> getAccountsByProvider(String providerProgrammaticName) {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return this.accountsById.values().stream().filter(info -> Objects.equals(info.providerProgrammaticName, providerProgrammaticName)).toList();
        }
    }

    @Deprecated
    public List<AccountInfo> getProviderOtherAccountsByAccountId(String accountId, boolean includePrimary) {
        return this.getAccountsByProviderAccountId(accountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountInfo> getAccountsByProviderAccountId(String accountId) {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            AccountInfo accountInfo = this.accountsById.get(accountId);
            String providerProgrammaticName = accountInfo.providerProgrammaticName;
            return this.accountsById.values().stream().filter(info -> Objects.equals(info.providerProgrammaticName, providerProgrammaticName)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getProvidersWithMultiAccounts() {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return this.accountsById.values().stream().map(info -> info.providerProgrammaticName).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getAccountById(String accountId) {
        Map<String, AccountInfo> map = this.accountsById;
        synchronized (map) {
            return this.accountsById.get(accountId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AccountInfo> getAccountsByAlias(String alias) {
        Preconditions.checkNotNull((Object)alias);
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.entrySet().stream().filter(entry -> Objects.equals(((AccountInfoMessageKey)entry.getKey()).alias, alias)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAliasesByAccountId(String accountId) {
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.keySet().stream().filter(accountInfo -> accountInfo.accountId.equals(accountId)).map(accountInfo -> accountInfo.alias).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountInfo getAccountByOrderId(String orderId) {
        Map<String, OrderInfo> map = this.ordersByOrderId;
        synchronized (map) {
            OrderInfo orderInfo = this.ordersByOrderId.get(orderId);
            if (orderInfo == null) {
                return null;
            }
            String accountId = orderInfo.accountId;
            if (accountId == null) {
                return null;
            }
            Map<String, AccountInfo> map2 = this.accountsById;
            synchronized (map2) {
                return this.accountsById.get(accountId);
            }
        }
    }

    @Deprecated
    public Boolean isPrimaryAccountOrNull(String accountId) {
        return null;
    }

    @Deprecated
    public boolean isPrimaryAccount(String accountId) {
        return false;
    }

    @Deprecated
    public Boolean isPrimaryAccountOrderOrNull(String orderId) {
        return this.isAccountSelectedForOrderIdOrNull(orderId);
    }

    @Deprecated
    public boolean isPrimaryAccountOrder(String orderId) {
        return this.isAccountSelectedForOrderId(orderId);
    }

    public boolean isAccountSelectedForOrderId(String orderId) {
        Boolean isSelectedAccountOrderOrNull = this.isAccountSelectedForOrderIdOrNull(orderId);
        return isSelectedAccountOrderOrNull == null || isSelectedAccountOrderOrNull != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isAccountSelectedForOrderIdOrNull(String orderId) {
        String selectedAccountIdForAlias;
        String orderAccountId;
        String orderAlias;
        Map<String, OrderInfo> map = this.ordersByOrderId;
        synchronized (map) {
            OrderInfo order = this.ordersByOrderId.get(orderId);
            if (order == null) {
                return null;
            }
            orderAlias = order.instrumentAlias;
            orderAccountId = order.accountId;
        }
        if (this.getAccountById(orderAccountId) == null) {
            return null;
        }
        Map<String, String> map2 = this.selectedAccountIdByAlias;
        synchronized (map2) {
            selectedAccountIdForAlias = this.selectedAccountIdByAlias.get(orderAlias);
        }
        if (selectedAccountIdForAlias == null) {
            return false;
        }
        return selectedAccountIdForAlias.equals(orderAccountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onUserMessage(Object message) {
        if (message instanceof TradingAccountsInfoMessage) {
            TradingAccountsInfoMessage accountMessage = (TradingAccountsInfoMessage)message;
            AccountInfoMessageKey key = new AccountInfoMessageKey(accountMessage.accountInfo.id, accountMessage.alias);
            Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
            synchronized (map) {
                boolean wasRemoved;
                if (accountMessage.isAdd) {
                    Map<String, AccountInfo> map2 = this.accountsById;
                    synchronized (map2) {
                        this.accountsById.put(accountMessage.accountInfo.id, accountMessage.accountInfo);
                    }
                    AccountInfo previousAccountInfo = this.accountsByIdAndAlias.put(key, accountMessage.accountInfo);
                    return previousAccountInfo == null || previousAccountInfo.isPrimary != accountMessage.accountInfo.isPrimary;
                }
                boolean bl = wasRemoved = this.accountsByIdAndAlias.remove(key) != null;
                if (accountMessage.alias == null) {
                    boolean otherAccountsWereRemoved = this.accountsByIdAndAlias.entrySet().removeIf(entry -> ((AccountInfoMessageKey)entry.getKey()).accountId.equals(accountMessage.accountInfo.id));
                    wasRemoved = otherAccountsWereRemoved || wasRemoved;
                }
                String accountId = accountMessage.accountInfo.id;
                this.removeAccountIfNoAlias(accountId);
                this.removeSelectedAccountByAliases(accountId, accountMessage.alias);
                return wasRemoved;
            }
        }
        if (message instanceof SelectedAccountChangedMessage) {
            String previousAccountId;
            boolean newAlias;
            SelectedAccountChangedMessage selectedAccountChangedMessage = (SelectedAccountChangedMessage)message;
            Map<String, Object> map = this.selectedAccountIdByAlias;
            synchronized (map) {
                newAlias = !this.selectedAccountIdByAlias.containsKey(selectedAccountChangedMessage.alias);
                previousAccountId = this.selectedAccountIdByAlias.put(selectedAccountChangedMessage.alias, selectedAccountChangedMessage.accountId);
            }
            map = this.aliasesBySelectedAccountId;
            synchronized (map) {
                if (selectedAccountChangedMessage.accountId != null) {
                    Set aliases = this.aliasesBySelectedAccountId.computeIfAbsent(selectedAccountChangedMessage.accountId, k -> new HashSet());
                    aliases.add(selectedAccountChangedMessage.alias);
                } else {
                    Set<String> aliases = this.aliasesBySelectedAccountId.get(previousAccountId);
                    if (aliases != null) {
                        aliases.remove(selectedAccountChangedMessage.alias);
                        if (aliases.isEmpty()) {
                            this.aliasesBySelectedAccountId.remove(previousAccountId);
                        }
                    }
                }
            }
            return newAlias || !Objects.equals(previousAccountId, selectedAccountChangedMessage.accountId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TradingAccountsInfoMessage> generateMessagesFromAccountsList() {
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.entrySet().stream().map(entry -> new TradingAccountsInfoMessage(((AccountInfoMessageKey)entry.getKey()).alias, (AccountInfo)entry.getValue(), true)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TradingAccountsInfoMessage> generateMessagesFromAccountsList(String alias) {
        Map<AccountInfoMessageKey, AccountInfo> map = this.accountsByIdAndAlias;
        synchronized (map) {
            return this.accountsByIdAndAlias.entrySet().stream().filter(entry -> Objects.equals(((AccountInfoMessageKey)entry.getKey()).alias, alias)).map(entry -> new TradingAccountsInfoMessage(((AccountInfoMessageKey)entry.getKey()).alias, (AccountInfo)entry.getValue(), true)).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectedAccountChangedMessage> generateMessagesFromSelectedAccounts() {
        Map<String, String> map = this.selectedAccountIdByAlias;
        synchronized (map) {
            return this.selectedAccountIdByAlias.entrySet().stream().map(entry -> new SelectedAccountChangedMessage((String)entry.getKey(), (String)entry.getValue())).toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccountIfNoAlias(String accountId) {
        boolean hasAnyAlias = this.accountsByIdAndAlias.keySet().stream().anyMatch(accountInfo -> accountInfo.accountId.equals(accountId));
        if (!hasAnyAlias) {
            Map<String, AccountInfo> map = this.accountsById;
            synchronized (map) {
                this.accountsById.remove(accountId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedAccountByAliases(String accountId, String alias) {
        Map<String, Set<String>> map = this.aliasesBySelectedAccountId;
        synchronized (map) {
            Map<String, String> map2 = this.selectedAccountIdByAlias;
            synchronized (map2) {
                if (alias == null) {
                    Set<String> aliases = this.aliasesBySelectedAccountId.remove(accountId);
                    if (aliases != null) {
                        for (String aliasBySelectedAccountId : aliases) {
                            this.selectedAccountIdByAlias.remove(aliasBySelectedAccountId);
                        }
                    }
                } else {
                    Set<String> aliases = this.aliasesBySelectedAccountId.get(accountId);
                    if (aliases != null) {
                        aliases.remove(alias);
                        if (aliases.isEmpty()) {
                            this.aliasesBySelectedAccountId.remove(accountId);
                        }
                        if (this.selectedAccountIdByAlias.containsKey(alias) && Objects.equals(accountId, this.selectedAccountIdByAlias.get(alias))) {
                            this.selectedAccountIdByAlias.remove(alias);
                        }
                    } else {
                        this.aliasesBySelectedAccountId.remove(accountId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        Map<String, OrderInfo> map = this.ordersByOrderId;
        synchronized (map) {
            this.ordersByOrderId.put(orderInfoUpdate.orderId, orderInfoUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getOrderIdsByAccountAndAlias(String accountId, String alias) {
        Map<String, OrderInfo> map = this.ordersByOrderId;
        synchronized (map) {
            return this.ordersByOrderId.entrySet().stream().filter(entry -> {
                OrderInfo order = (OrderInfo)entry.getValue();
                return Objects.equals(order.accountId, accountId) && Objects.equals(order.instrumentAlias, alias);
            }).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderInfoUpdate getOrderInfoUpdate(String orderId) {
        Map<String, OrderInfo> map = this.ordersByOrderId;
        synchronized (map) {
            OrderInfo orderInfo = this.ordersByOrderId.get(orderId);
            if (orderInfo instanceof OrderInfoUpdate) {
                return (OrderInfoUpdate)orderInfo;
            }
            return null;
        }
    }

    private record AccountInfoMessageKey(String accountId, String alias) {
    }
}

