/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.concurrent.atomic.AtomicLong;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.NanoClock;
import velox.api.layer1.data.OrderUpdateParameters;

@Layer1ApiPublic
public class OrderCancelParameters
extends OrderUpdateParameters {
    private static final AtomicLong UNIQUE_BATCH_NUMBER_GENERATOR = new AtomicLong(NanoClock.currentTimeNanos());
    public final long batchId;
    public final boolean batchEnd;

    public OrderCancelParameters(String orderId) {
        this(orderId, true);
    }

    public OrderCancelParameters(String orderId, boolean batchEnd) {
        this(orderId, UNIQUE_BATCH_NUMBER_GENERATOR.incrementAndGet(), batchEnd);
    }

    public OrderCancelParameters(String orderId, long batchId, boolean batchEnd) {
        super(orderId);
        this.batchId = batchId;
        this.batchEnd = batchEnd;
    }

    private OrderCancelParameters(Builder builder) {
        super(builder);
        this.batchId = builder.batchId != null ? builder.batchId.longValue() : UNIQUE_BATCH_NUMBER_GENERATOR.incrementAndGet();
        this.batchEnd = builder.batchEnd;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass()) + "{super=" + super.toString() + ", batchId=" + this.batchId + ", batchEnd=" + this.batchEnd + "}";
    }

    @Layer1ApiPublic
    public static final class Builder
    extends OrderUpdateParameters.Builder<Builder> {
        private Long batchId = null;
        private boolean batchEnd = true;

        public Builder(String orderId) {
            super(orderId);
        }

        private Builder(OrderCancelParameters parameters) {
            super(parameters);
            this.batchId = parameters.batchId;
            this.batchEnd = parameters.batchEnd;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setBatchId(Long batchId) {
            this.batchId = batchId;
            return this.self();
        }

        public Long getBatchId() {
            return this.batchId;
        }

        public Builder setBatchEnd(boolean batchEnd) {
            this.batchEnd = batchEnd;
            return this.self();
        }

        public boolean isBatchEnd() {
            return this.batchEnd;
        }

        @Override
        public OrderCancelParameters build() {
            return new OrderCancelParameters(this);
        }
    }
}

