/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import java.util.function.Function;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.annotations.Layer1StrategyName;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;
import velox.api.layer1.messages.Layer1ApiSoundAlertDeclarationMessage;
import velox.api.layer1.utils.IdHelper;
import velox.gui.StrategyPanel;

@Layer1ApiPublic
public class Layer1ApiAlertGuiMessage
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    public final String id;
    public final Class<?> source;
    public final String strategyName;
    public final Function<Layer1ApiSoundAlertDeclarationMessage, StrategyPanel[]> guiPanelsProvider;
    public final boolean isAdd;

    private Layer1ApiAlertGuiMessage(Builder builder) {
        this.id = builder.id;
        this.guiPanelsProvider = builder.guiPanelsProvider;
        this.source = builder.source;
        this.isAdd = builder.isAdd;
        if (this.source == null) {
            throw new IllegalArgumentException("source field is mandatory");
        }
        if (this.source.getAnnotation(Layer1StrategyName.class) == null) {
            throw new IllegalArgumentException("source is not annotated with " + Layer1StrategyName.class.getSimpleName() + ". Note that it must be the entry point class of the module submitting the alert.");
        }
        this.strategyName = this.source.getAnnotation(Layer1StrategyName.class).value();
    }

    public String toString() {
        return "Layer1ApiAlertGuiMessage [id='" + this.id + "', source=" + String.valueOf(this.source) + ", strategyName='" + this.strategyName + "', isAdd=" + this.isAdd + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Layer1ApiPublic
    public static final class Builder {
        private String id = IdHelper.generateShortUuid();
        private Class<?> source;
        private Function<Layer1ApiSoundAlertDeclarationMessage, StrategyPanel[]> guiPanelsProvider;
        private boolean isAdd = true;

        private Builder() {
        }

        public Builder(Layer1ApiAlertGuiMessage message) {
            this.id = message.id;
            this.source = message.source;
            this.guiPanelsProvider = message.guiPanelsProvider;
            this.isAdd = message.isAdd;
        }

        public Builder setSource(Class<?> source) {
            this.source = source;
            return this;
        }

        public Builder setGuiPanelsProvider(Function<Layer1ApiSoundAlertDeclarationMessage, StrategyPanel[]> guiPanelsProvider) {
            this.guiPanelsProvider = guiPanelsProvider;
            return this;
        }

        public Builder setIsAdd(boolean isAdd) {
            this.isAdd = isAdd;
            return this;
        }

        public Layer1ApiAlertGuiMessage build() {
            return new Layer1ApiAlertGuiMessage(this);
        }
    }
}

