/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.io.Serializable;
import java.util.Objects;
import velox.api.layer1.annotations.Layer1ApiPublic;

@Layer1ApiPublic
public class InstrumentCoreInfo
implements Serializable {
    private static final long serialVersionUID = 8348371739129190371L;
    public final String symbol;
    public final String exchange;
    public final String type;

    private InstrumentCoreInfo() {
        this(null, null, null);
    }

    public InstrumentCoreInfo(String symbol, String exchange, String type) {
        this.symbol = symbol;
        this.exchange = exchange;
        this.type = type;
    }

    protected InstrumentCoreInfo(BuilderBase<?> builder) {
        this.symbol = builder.symbol;
        this.exchange = builder.exchange;
        this.type = builder.type;
    }

    public BuilderBase<?> toBuilder() {
        Builder builder = new Builder();
        return builder.setFieldsFrom(this);
    }

    public String toString() {
        return "InstrumentCoreInfo [symbol=" + this.symbol + ", exchange=" + this.exchange + ", type=" + this.type + "]";
    }

    public int hashCode() {
        return Objects.hash(this.exchange, this.symbol, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstrumentCoreInfo)) {
            return false;
        }
        InstrumentCoreInfo other = (InstrumentCoreInfo)obj;
        return Objects.equals(this.exchange, other.exchange) && Objects.equals(this.symbol, other.symbol) && Objects.equals(this.type, other.type);
    }

    public InstrumentCoreInfo normalize() {
        return new InstrumentCoreInfo(this.symbol == null ? "" : this.symbol, this.exchange == null ? "" : this.exchange, this.type == null ? "" : this.type);
    }

    @Layer1ApiPublic
    public static abstract class BuilderBase<T extends BuilderBase<T>> {
        protected String symbol;
        protected String exchange;
        protected String type;

        protected abstract T self();

        public abstract InstrumentCoreInfo build();

        public T setFieldsFrom(InstrumentCoreInfo info) {
            this.symbol = info.symbol;
            this.exchange = info.exchange;
            this.type = info.type;
            return this.self();
        }

        public String getSymbol() {
            return this.symbol;
        }

        public T setSymbol(String symbol) {
            this.symbol = symbol;
            return this.self();
        }

        public String getExchange() {
            return this.exchange;
        }

        public T setExchange(String exchange) {
            this.exchange = exchange;
            return this.self();
        }

        public String getType() {
            return this.type;
        }

        public T setType(String type) {
            this.type = type;
            return this.self();
        }
    }

    @Layer1ApiPublic
    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InstrumentCoreInfo build() {
            return new InstrumentCoreInfo(this);
        }
    }
}

