/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import velox.api.layer1.annotations.Layer1StrategyName;
import velox.api.layer1.annotations.PublishWithoutJavadoc;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;
import velox.api.layer1.settings.StrategySettingsVersion;

@PublishWithoutJavadoc
public class Layer1ApiAddonStatisticsEventMessage
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    private static final Gson GSON = new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().enableComplexMapKeySerialization().create();
    public final String addonName;
    public final String message;

    public Layer1ApiAddonStatisticsEventMessage(Class<?> addon, String message) {
        Layer1StrategyName layer1ApiStrategyName = addon.getAnnotation(Layer1StrategyName.class);
        this.addonName = layer1ApiStrategyName != null ? layer1ApiStrategyName.value() : addon.getName();
        this.message = message;
    }

    public static Layer1ApiAddonStatisticsEventMessage createSettingsEventMessage(Class<?> addon, Object settings, String alias) {
        StrategySettingsVersion versionAnnotation = settings.getClass().getAnnotation(StrategySettingsVersion.class);
        int version = -1;
        if (versionAnnotation != null) {
            version = versionAnnotation.currentVersion();
        }
        String jsonSettings = GSON.toJson(settings);
        JsonObject jo = new JsonObject();
        jo.addProperty("type", "settings");
        jo.addProperty("settings_version", (Number)version);
        jo.addProperty("settings", jsonSettings);
        jo.addProperty("alias", alias);
        return new Layer1ApiAddonStatisticsEventMessage(addon, GSON.toJson((JsonElement)jo));
    }
}

