/*
 * Decompiled with CFR 0.152.
 */
package velox.gui.utils.localization;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.gui.utils.localization.BookmapLocale;

@Layer1ApiPublic
public class LocalizedTextUtils {
    public static int getCharCount(String text, ULocale locale) {
        BreakIterator breakIterator = BreakIterator.getCharacterInstance((ULocale)locale);
        breakIterator.setText(text);
        breakIterator.first();
        int length = 0;
        int i = breakIterator.next();
        while (i != -1) {
            ++length;
            i = breakIterator.next();
        }
        return length;
    }

    public static int getCharCount(String text) {
        return LocalizedTextUtils.getCharCount(text, BookmapLocale.getDefaultULocale());
    }

    public static String getCharAt(String text, int position, ULocale locale) {
        if (position < 0 || position >= LocalizedTextUtils.getCharCount(text, locale)) {
            throw new StringIndexOutOfBoundsException(String.format("Index '%d' for text '%s' is out of the bounds (text length: %d)", position, text, LocalizedTextUtils.getCharCount(text, locale)));
        }
        BreakIterator breakIterator = BreakIterator.getCharacterInstance((ULocale)locale);
        breakIterator.setText(text);
        int start = breakIterator.first();
        int end = breakIterator.next();
        int i = 0;
        while (end != -1) {
            if (i == position) {
                return text.substring(start, end);
            }
            start = end;
            end = breakIterator.next();
            ++i;
        }
        throw new RuntimeException("Logic error at getCharAt");
    }

    public static String getCharAt(String text, int position) {
        return LocalizedTextUtils.getCharAt(text, position, BookmapLocale.getCurrentULocale());
    }

    public static String toUpperCase(String text, ULocale locale) {
        return UCharacter.toUpperCase((ULocale)locale, (String)text);
    }

    public static String toUpperCase(String text) {
        return LocalizedTextUtils.toUpperCase(text, BookmapLocale.getCurrentULocale());
    }

    public static String toLowerCase(String text, ULocale locale) {
        return UCharacter.toLowerCase((ULocale)locale, (String)text);
    }

    public static String toLowerCase(String text) {
        return LocalizedTextUtils.toLowerCase(text, BookmapLocale.getCurrentULocale());
    }
}

