/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.datastructure.events.DepthAggregationEvent;

@Layer1ApiPublic
public class OrderBook {
    public static final int NONE = Integer.MAX_VALUE;
    protected TreeMap<Integer, Long> bidMap = new TreeMap(Collections.reverseOrder());
    protected TreeMap<Integer, Long> askMap = new TreeMap();

    public OrderBook() {
    }

    public OrderBook(OrderBook orderBook) {
        this();
        this.askMap.putAll(orderBook.askMap);
        this.bidMap.putAll(orderBook.bidMap);
    }

    public void onUpdate(boolean isBid, int price, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size must be non negative isBid=" + isBid + " price=" + price + " size=" + size);
        }
        if (isBid) {
            this.updateMap(this.bidMap, price, size);
        } else {
            this.updateMap(this.askMap, price, size);
        }
    }

    public void onUpdate(DepthAggregationEvent depthAggregationEvent) {
        depthAggregationEvent.bidsMap.forEach((price, size) -> this.onUpdate(true, (int)price, size.intValue()));
        depthAggregationEvent.asksMap.forEach((price, size) -> this.onUpdate(false, (int)price, size.intValue()));
    }

    protected void updateMap(TreeMap<Integer, Long> updatedMap, int price, long size) {
        if (size <= 0L) {
            updatedMap.remove(price);
        } else {
            updatedMap.put(price, size);
        }
    }

    public int getBestBidPriceOrNone() {
        return this.getFirstKeyOrNone(this.bidMap);
    }

    public int getBestAskPriceOrNone() {
        return this.getFirstKeyOrNone(this.askMap);
    }

    public double getMidPriceOrNan() {
        int bestAskPriceOrNone = this.getBestAskPriceOrNone();
        int bestBidPriceOrNone = this.getBestBidPriceOrNone();
        if (bestAskPriceOrNone == Integer.MAX_VALUE || bestBidPriceOrNone == Integer.MAX_VALUE) {
            return Double.NaN;
        }
        return ((double)bestBidPriceOrNone + (double)bestAskPriceOrNone) / 2.0;
    }

    public int getFirstKeyOrNone(TreeMap<Integer, Long> map) {
        Map.Entry<Integer, Long> bestEntry = map.firstEntry();
        return bestEntry == null ? Integer.MAX_VALUE : bestEntry.getKey();
    }

    public long getFirstValueOrNone(TreeMap<Integer, Long> map) {
        Map.Entry<Integer, Long> bestEntry = map.firstEntry();
        return bestEntry == null ? Integer.MAX_VALUE : bestEntry.getValue();
    }

    public Integer[] levels(boolean isBid) {
        if (isBid) {
            return this.bidMap.keySet().toArray(new Integer[this.bidMap.size()]);
        }
        return this.askMap.keySet().toArray(new Integer[this.askMap.size()]);
    }

    public int getWorstBidPriceOrNone() {
        return this.getLastKeyOrNone(this.bidMap);
    }

    public int getWorstAskPriceOrNone() {
        return this.getLastKeyOrNone(this.askMap);
    }

    public int getLastKeyOrNone(TreeMap<Integer, Long> map) {
        Map.Entry<Integer, Long> bestEntry = map.lastEntry();
        return bestEntry == null ? Integer.MAX_VALUE : bestEntry.getKey();
    }

    public Map<Integer, Long> levels(boolean isBid, int from, int to) {
        return this.levels(isBid, from, true, to, true);
    }

    public Map<Integer, Long> levels(boolean isBid, int from, boolean fromInclusive, int to, boolean toInclusive) {
        if (isBid) {
            return new HashMap<Integer, Long>(this.bidMap.subMap(to, toInclusive, from, fromInclusive));
        }
        return new HashMap<Integer, Long>(this.askMap.subMap(from, fromInclusive, to, toInclusive));
    }

    public long getSizeFor(boolean isBid, int price) {
        return this.getSizeFor(isBid, price, Integer.MAX_VALUE);
    }

    public long getSizeFor(boolean isBid, int price, long defaultSize) {
        Long value = null;
        value = isBid ? this.bidMap.get(price) : this.askMap.get(price);
        return (Long)ObjectUtils.firstNonNull((Object[])new Long[]{value, defaultSize});
    }

    public void clear() {
        this.bidMap.clear();
        this.askMap.clear();
    }

    public TreeMap<Integer, Long> getBidMap() {
        return this.bidMap;
    }

    public TreeMap<Integer, Long> getAskMap() {
        return this.askMap;
    }

    public boolean isEmpty() {
        return this.bidMap.isEmpty() && this.askMap.isEmpty();
    }

    public String toString() {
        return "bids: " + this.bidMap.toString() + " // asks: " + this.askMap.toString();
    }
}

