/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.AccountInfo;

@Layer1ApiPublic
public class SelectAccountMessage {
    public final AccountInfo[] accountsInfo;
    private final CountDownLatch latch = new CountDownLatch(1);
    private int selectedIndex = -1;
    private final Object selectedIndexLock = new Object();

    public SelectAccountMessage(AccountInfo[] accountsInfo) {
        this.accountsInfo = accountsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int selectedIndex) {
        if (selectedIndex < 0 || selectedIndex >= this.accountsInfo.length) {
            throw new IndexOutOfBoundsException("index:" + selectedIndex + " size:" + this.accountsInfo.length);
        }
        Object object = this.selectedIndexLock;
        synchronized (object) {
            if (this.selectedIndex != -1) {
                throw new IllegalStateException("Account already selected");
            }
            this.selectedIndex = selectedIndex;
            this.latch.countDown();
        }
    }

    public int get() throws InterruptedException {
        this.latch.await();
        return this.selectedIndex;
    }

    public String toString() {
        return "SelectAccountMessage{accountsInfo=" + Arrays.toString(this.accountsInfo) + "}";
    }
}

