/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.ArrayList;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.BalanceInfo;

@Layer1ApiPublic
public class BalanceInfoBuilder {
    private String accountName;
    private String accountId;
    private ArrayList<BalanceInfo.BalanceInCurrency> balancesInCurrency = new ArrayList();

    public BalanceInfo build() {
        if (this.accountId != null && this.accountName != null) {
            throw new IllegalArgumentException("Both account name and account id are set. Only one should be set.");
        }
        if (this.accountName != null) {
            return new BalanceInfo(this.accountName, this.balancesInCurrency);
        }
        return new BalanceInfo(this.balancesInCurrency, this.accountId);
    }

    public BalanceInfoBuilder updateBalanceInCurrency(BalanceInfo.BalanceInCurrency balanceInCurrency) {
        String updatedCurrency = balanceInCurrency.currency;
        int position = -1;
        for (int i = 0; i < this.balancesInCurrency.size(); ++i) {
            String currency = this.balancesInCurrency.get((int)i).currency;
            if ((currency != null || updatedCurrency != null) && (currency == null || !currency.equals(updatedCurrency))) continue;
            position = i;
        }
        if (position == -1) {
            this.balancesInCurrency.add(balanceInCurrency);
        } else {
            this.balancesInCurrency.set(position, balanceInCurrency);
        }
        return this;
    }

    @Deprecated
    public String getAccountName() {
        return this.accountName;
    }

    @Deprecated
    public BalanceInfoBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public BalanceInfoBuilder setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public ArrayList<BalanceInfo.BalanceInCurrency> getBalancesInCurrency() {
        return this.balancesInCurrency;
    }

    public BalanceInfoBuilder setBalancesInCurrency(ArrayList<BalanceInfo.BalanceInCurrency> balancesInCurrency) {
        this.balancesInCurrency = balancesInCurrency;
        return this;
    }
}

