/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.messages;

import java.util.function.Predicate;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.annotations.Layer1StrategyName;
import velox.api.layer1.layers.Layer1ApiStrategiesEchoMessagesLayer;
import velox.api.layer1.utils.IdHelper;

@Layer1ApiPublic
public class Layer1ApiSoundAlertDeclarationMessage
implements Layer1ApiStrategiesEchoMessagesLayer.StrategyEchoMessageFromLayer {
    public final String id;
    public final String triggerDescription;
    public final Class<?> source;
    public final String strategyName;
    public final Predicate<String> aliasMatcher;
    public final boolean isPopupAllowed;
    public final boolean isSoundAllowed;
    public final boolean isRepeated;
    public final boolean isAdd;

    private Layer1ApiSoundAlertDeclarationMessage(Builder builder) {
        this.id = builder.id;
        this.triggerDescription = builder.triggerDescription;
        this.source = builder.source;
        this.aliasMatcher = builder.aliasMatcher;
        this.isPopupAllowed = builder.isPopupAllowed;
        this.isSoundAllowed = builder.isSoundAllowed;
        this.isRepeated = builder.isRepeated;
        this.isAdd = builder.isAdd;
        if (this.source == null) {
            throw new IllegalArgumentException("source field is mandatory");
        }
        if (this.source.getAnnotation(Layer1StrategyName.class) == null) {
            throw new IllegalArgumentException("source is not annotated with " + Layer1StrategyName.class.getSimpleName() + ". Note that it must be the entry point class of the module submitting the alert.");
        }
        this.strategyName = this.source.getAnnotation(Layer1StrategyName.class).value();
    }

    public String toString() {
        return "Layer1ApiSoundAlertDeclarationMessage [id='" + this.id + "', triggerDescription='" + this.triggerDescription + "', source=" + String.valueOf(this.source) + ", strategyName='" + this.strategyName + "', isPopupAllowed=" + this.isPopupAllowed + ", isSoundAllowed=" + this.isSoundAllowed + ", isRepeated=" + this.isRepeated + ", isAdd=" + this.isAdd + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Layer1ApiPublic
    public static final class Builder {
        private String id = IdHelper.generateShortUuid();
        private String triggerDescription;
        private Class<?> source;
        private Predicate<String> aliasMatcher;
        private boolean isPopupAllowed;
        private boolean isSoundAllowed;
        private boolean isRepeated;
        private boolean isAdd = true;

        private Builder() {
        }

        public Builder(Layer1ApiSoundAlertDeclarationMessage message) {
            this.id = message.id;
            this.triggerDescription = message.triggerDescription;
            this.source = message.source;
            this.aliasMatcher = message.aliasMatcher;
            this.isPopupAllowed = message.isPopupAllowed;
            this.isSoundAllowed = message.isSoundAllowed;
            this.isRepeated = message.isRepeated;
            this.isAdd = message.isAdd;
        }

        public Builder setTriggerDescription(String triggerDescription) {
            this.triggerDescription = triggerDescription;
            return this;
        }

        public Builder setSource(Class<?> source) {
            this.source = source;
            return this;
        }

        public Builder setAliasMatcher(Predicate<String> aliasMatcher) {
            this.aliasMatcher = aliasMatcher;
            return this;
        }

        public Builder setPopupAllowed(boolean popupAllowed) {
            this.isPopupAllowed = popupAllowed;
            return this;
        }

        public Builder setSoundAllowed(boolean soundAllowed) {
            this.isSoundAllowed = soundAllowed;
            return this;
        }

        public Builder setRepeated(boolean repeated) {
            this.isRepeated = repeated;
            return this;
        }

        public Builder setIsAdd(boolean isAdd) {
            this.isAdd = isAdd;
            return this;
        }

        public Layer1ApiSoundAlertDeclarationMessage build() {
            if (this.aliasMatcher == null) {
                throw new IllegalArgumentException("aliasMatcher field is mandatory");
            }
            if (this.source == null) {
                throw new IllegalArgumentException("source field is mandatory");
            }
            if (this.source.getAnnotation(Layer1StrategyName.class) == null) {
                throw new IllegalArgumentException("source is not annotated with " + Layer1StrategyName.class.getSimpleName() + ". Note that it must be the entry point class of the module submitting the message.");
            }
            return new Layer1ApiSoundAlertDeclarationMessage(this);
        }
    }
}

