/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.common.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.helper.PriorityThreadPoolExecutor;
import velox.utils.concurrent.AutoShutdownForwardingExecutorService;
import velox.utils.concurrent.AutoShutdownForwardingScheduledExecutorService;

@Layer1ApiPublic
public final class ExecutorsHelper {
    private static final RejectedExecutionHandler DEFAULT_HANDLER = new ThreadPoolExecutor.AbortPolicy();

    private ExecutorsHelper() {
    }

    @Deprecated
    public static ThreadPoolExecutor newOnDemandSingleThreadExecutor(String name) {
        return ExecutorsHelper.newThreadPoolExecutor(0, 1, name);
    }

    public static ExecutorService newOnDemandSingleThreadExecutorService(String name) {
        return new AutoShutdownForwardingExecutorService((ExecutorService)ExecutorsHelper.newThreadPoolExecutor(0, 1, name));
    }

    @Deprecated
    public static ThreadPoolExecutor newOnDemandSingleThreadPriorityExecutor(String name) {
        return ExecutorsHelper.newThreadPoolPriorityExecutor(0, 1, name);
    }

    public static ExecutorService newOnDemandSingleThreadPriorityExecutorService(String name) {
        return new AutoShutdownForwardingExecutorService((ExecutorService)ExecutorsHelper.newThreadPoolPriorityExecutor(0, 1, name));
    }

    @Deprecated
    public static ThreadPoolExecutor newSingleThreadExecutor(String name) {
        return ExecutorsHelper.newThreadPoolExecutor(1, 1, name);
    }

    public static ExecutorService newSingleThreadExecutorService(String name) {
        return new AutoShutdownForwardingExecutorService((ExecutorService)ExecutorsHelper.newThreadPoolExecutor(1, 1, name));
    }

    @Deprecated
    public static ThreadPoolExecutor newSingleThreadExecutor(String name, Consumer<Boolean> queueEmptyCallback) {
        return ExecutorsHelper.newThreadPoolExecutor(1, 1, name, queueEmptyCallback);
    }

    public static ExecutorService newSingleThreadExecutorService(String name, Consumer<Boolean> queueEmptyCallback) {
        return new AutoShutdownForwardingExecutorService((ExecutorService)ExecutorsHelper.newThreadPoolExecutor(1, 1, name, queueEmptyCallback));
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String name, final Consumer<Boolean> queueEmptyCallback) {
        return ExecutorsHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, name, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(){
            private static final long serialVersionUID = 247146755807970628L;
            private final AtomicBoolean wasEmptyLastTime = new AtomicBoolean(true);

            private void handleSizeChange() {
                boolean isEmpty = this.isEmpty();
                if (this.wasEmptyLastTime.getAndSet(isEmpty) != isEmpty) {
                    queueEmptyCallback.accept(isEmpty);
                }
            }

            @Override
            public void put(@NonNull Runnable e) throws InterruptedException {
                super.put(e);
                this.handleSizeChange();
            }

            @Override
            public boolean offer(@NonNull Runnable e) {
                boolean offer = super.offer(e);
                this.handleSizeChange();
                return offer;
            }

            @Override
            public boolean offer(Runnable e, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
                boolean offer = super.offer(e, timeout, unit);
                this.handleSizeChange();
                return offer;
            }

            @Override
            public @NonNull Runnable take() throws InterruptedException {
                Runnable take = (Runnable)super.take();
                this.handleSizeChange();
                return take;
            }

            @Override
            public Runnable poll() {
                Runnable poll = (Runnable)super.poll();
                this.handleSizeChange();
                return poll;
            }

            @Override
            public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
                Runnable poll = (Runnable)super.poll(timeout, unit);
                this.handleSizeChange();
                return poll;
            }
        });
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String name) {
        return ExecutorsHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, name, new LinkedBlockingQueue<Runnable>());
    }

    @Deprecated
    public static ThreadPoolExecutor newFixedThreadPoolExecutor(int poolSize, String name) {
        return ExecutorsHelper.newThreadPoolExecutor(poolSize, poolSize, name);
    }

    public static ExecutorService newFixedThreadPoolExecutorService(int poolSize, String name) {
        return new AutoShutdownForwardingExecutorService((ExecutorService)ExecutorsHelper.newThreadPoolExecutor(poolSize, poolSize, name));
    }

    public static ThreadPoolExecutor newThreadPoolPriorityExecutor(int corePoolSize, int maximumPoolSize, String name) {
        return ExecutorsHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, name, new PriorityBlockingQueue<Runnable>());
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String name, BlockingQueue<Runnable> queue) {
        return ExecutorsHelper.newThreadPoolExecutor(corePoolSize, maximumPoolSize, name, queue, DEFAULT_HANDLER);
    }

    public static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String name, BlockingQueue<Runnable> queue, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, corePoolSize == maximumPoolSize ? 0L : 30L, TimeUnit.SECONDS, queue, new NamedThreadFactory(name), handler);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String name) {
        return new AutoShutdownForwardingScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, new NamedThreadFactory(name)));
    }

    public static PriorityThreadPoolExecutor newOnDemandPriorityThreadPoolExecutor(String name) {
        return new PriorityThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory(name));
    }

    static final class NamedThreadFactory
    implements ThreadFactory {
        private static final Map<String, AtomicInteger> POOL_NUMBERS = Collections.synchronizedMap(new HashMap());
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String name) {
            name = String.valueOf(name);
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-" + POOL_NUMBERS.computeIfAbsent(name, k -> new AtomicInteger(1)).getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static class PrioritizedRunnable
    implements Runnable,
    Comparable<PrioritizedRunnable> {
        private final Runnable runnable;
        private final int priority;

        public PrioritizedRunnable(Runnable runnable, int priority) {
            this.runnable = runnable;
            this.priority = priority;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public int compareTo(PrioritizedRunnable o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

