/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.data;

import java.util.Objects;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.AccountInfoBuilder;
import velox.api.layer1.data.AccountType;

@Layer1ApiPublic
public class AccountInfo {
    public final String id;
    public final String summary;
    public final String shortName;
    public final String providerProgrammaticName;
    @Deprecated
    public final boolean isPrimary;
    public final AccountType accountType;
    public boolean isHidden = false;

    @Deprecated
    public AccountInfo(String id) {
        this.id = id;
        this.summary = id;
        this.shortName = null;
        this.providerProgrammaticName = null;
        this.isPrimary = false;
        this.accountType = AccountType.UNKNOWN;
    }

    AccountInfo(String id, String summary, String providerProgrammaticName, boolean isPrimary) {
        this(id, summary, null, providerProgrammaticName, isPrimary, AccountType.UNKNOWN, false);
    }

    AccountInfo(String id, String summary, String shortName, String providerProgrammaticName, boolean isPrimary, AccountType accountType, boolean isHidden) {
        this.id = id;
        this.summary = summary;
        this.shortName = shortName;
        this.providerProgrammaticName = providerProgrammaticName;
        this.isPrimary = isPrimary;
        this.accountType = accountType;
        this.isHidden = isHidden;
    }

    public AccountInfoBuilder toBuilder() {
        AccountInfoBuilder builder = new AccountInfoBuilder(this.id, this.summary, this.isPrimary).setAccountType(this.accountType).setHidden(this.isHidden);
        builder.setProviderProgrammaticName(this.providerProgrammaticName);
        builder.setShortName(this.shortName);
        return builder;
    }

    public String toString() {
        return "{id=" + this.id + ", summary=" + this.summary + ", shortName=" + this.shortName + ", providerProgrammaticName=" + this.providerProgrammaticName + ", isPrimary=" + this.isPrimary + ", accountType=" + String.valueOf((Object)this.accountType) + ", isHidden=" + this.isHidden + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountInfo)) {
            return false;
        }
        AccountInfo that = (AccountInfo)o;
        return this.isPrimary == that.isPrimary && this.accountType == that.accountType && this.isHidden == that.isHidden && Objects.equals(this.id, that.id) && Objects.equals(this.summary, that.summary) && Objects.equals(this.shortName, that.shortName) && Objects.equals(this.providerProgrammaticName, that.providerProgrammaticName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.summary, this.shortName, this.isPrimary, this.accountType, this.isHidden, this.providerProgrammaticName});
    }

    public boolean isSimulated() {
        return this.accountType == AccountType.SIMULATED;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }
}

