/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.layers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import velox.api.layer1.Layer1ApiProvider;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.common.Log;
import velox.api.layer1.layers.Layer1ApiRelay;

@Layer1ApiPublic
public class Layer1ApiDepthFreezer
extends Layer1ApiRelay {
    private final HashMap<String, Instrument> frozenInstruments = new HashMap();

    public Layer1ApiDepthFreezer(Layer1ApiProvider provider) {
        super(provider);
    }

    @Override
    public void onDepth(String alias, boolean isBid, int price, int size) {
        Instrument instrument = this.frozenInstruments.get(alias);
        if (instrument == null) {
            super.onDepth(alias, isBid, price, size);
        } else {
            instrument.onDepth(isBid, price, size);
        }
    }

    @Override
    public void onUserMessage(Object data) {
        if (data instanceof DepthFreezeRequest) {
            DepthFreezeRequest freezeRequest = (DepthFreezeRequest)data;
            String alias = freezeRequest.alias;
            if (freezeRequest.freeze) {
                Instrument previous = this.frozenInstruments.putIfAbsent(alias, new Instrument(freezeRequest));
                if (previous != null) {
                    Log.warn("Depth was frozen twice for " + alias);
                }
            } else {
                Instrument instrument = this.frozenInstruments.remove(alias);
                if (instrument == null) {
                    Log.warn("unfreezing instrument that was not frozen: " + alias);
                } else {
                    for (Map.Entry<Integer, Integer> entry : instrument.asks.entrySet()) {
                        super.onDepth(alias, false, entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<Integer, Integer> entry : instrument.bids.entrySet()) {
                        super.onDepth(alias, true, entry.getKey(), entry.getValue());
                    }
                }
            }
        } else {
            super.onUserMessage(data);
        }
    }

    private class Instrument {
        private TreeMap<Integer, Integer> bids = new TreeMap(Collections.reverseOrder());
        private TreeMap<Integer, Integer> asks = new TreeMap();
        private String alias;
        private long freezeEndTime;

        public Instrument(DepthFreezeRequest freezeRequest) {
            this.alias = freezeRequest.alias;
            this.freezeEndTime = freezeRequest.freezeEndTime;
        }

        public void onDepth(boolean isBid, int price, int size) {
            (isBid ? this.bids : this.asks).put(price, size);
            if (this.freezeEndTime < Layer1ApiDepthFreezer.this.getCurrentTime()) {
                Layer1ApiDepthFreezer.this.onUserMessage(new DepthFreezeRequest(this.alias, false));
            }
        }
    }

    @Layer1ApiPublic
    public static class DepthFreezeRequest {
        public final String alias;
        public final boolean freeze;
        public final long freezeEndTime;

        public DepthFreezeRequest(String alias, boolean freeze, long freezeEndTime) {
            this.alias = alias;
            this.freeze = freeze;
            this.freezeEndTime = freezeEndTime;
        }

        public DepthFreezeRequest(String alias, boolean freeze) {
            this(alias, freeze, Long.MAX_VALUE);
        }
    }
}

