/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.providers.data;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import velox.api.layer1.annotations.Layer1ApiPublic;
import velox.api.layer1.data.TradeInfo;

@Layer1ApiPublic
public final class TradeAggregator
implements Runnable {
    private final Object lock = new Object();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture = this.scheduler.schedule(() -> {}, 0L, TimeUnit.NANOSECONDS);
    private ScheduledFuture<?> scheduledStopFuture;
    private final TradeAggregatorConsumer callback;
    private String lastTicketId;
    private double lastPrice;
    private boolean lastIsBidAggressor;
    private boolean lastIsOtc;

    public TradeAggregator(TradeAggregatorConsumer callback) {
        this.scheduleStopTask();
        this.callback = callback;
    }

    private boolean getIsExecutionStartImpl(double aCurrentPrice, String aTicketId, boolean isBidAggressor, boolean isOtc) {
        if (!this.scheduledStopFuture.isDone()) {
            this.scheduledStopFuture.cancel(true);
        }
        if (!this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
            if (StringUtils.equals((CharSequence)aTicketId, (CharSequence)this.lastTicketId) && this.lastIsBidAggressor == isBidAggressor && this.lastIsOtc == isOtc) {
                this.scheduledFuture = this.scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
                return false;
            }
            this.callback.onTrade(this.lastPrice, 0, new TradeInfo(this.lastIsOtc, this.lastIsBidAggressor, false, true));
        }
        this.lastPrice = aCurrentPrice;
        this.lastIsBidAggressor = isBidAggressor;
        this.lastIsOtc = isOtc;
        this.lastTicketId = aTicketId;
        this.scheduledFuture = this.scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
        return true;
    }

    public void onTrade(double price, String aTicketId, boolean isBidAggressor, boolean isOtc, int size) {
        this.onTrade(price, aTicketId, isBidAggressor, isOtc, size, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrade(double price, String aTicketId, boolean isBidAggressor, boolean isOtc, int size, String aggressorOrderId, String passiveOrderId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.scheduler.isShutdown()) {
                this.scheduler = Executors.newScheduledThreadPool(1);
            }
            boolean isExecutionStart = this.getIsExecutionStartImpl(price, aTicketId, isBidAggressor, isOtc);
            TradeInfo tradeInfo = new TradeInfo(isOtc, isBidAggressor, isExecutionStart, false, aggressorOrderId, passiveOrderId);
            this.callback.onTrade(price, size, tradeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (Thread.interrupted()) {
                return;
            }
            this.callback.onTrade(this.lastPrice, 0, new TradeInfo(this.lastIsOtc, this.lastIsBidAggressor, false, true));
            this.scheduleStopTask();
        }
    }

    private void scheduleStopTask() {
        this.scheduledStopFuture = this.scheduler.schedule(this::shutdownIfNotInterrupted, 5L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownIfNotInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            if (Thread.interrupted()) {
                return;
            }
            this.scheduler.shutdown();
        }
    }

    @Layer1ApiPublic
    public static interface TradeAggregatorConsumer {
        public void onTrade(double var1, int var3, TradeInfo var4);
    }
}

