/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import velox.api.layer1.data.BalanceInfo;
import velox.api.layer1.data.ExecutionInfo;
import velox.api.layer1.data.InstrumentInfo;
import velox.api.layer1.data.MarketMode;
import velox.api.layer1.data.OrderInfoUpdate;
import velox.api.layer1.data.StatusInfo;
import velox.api.layer1.data.TradeInfo;
import velox.api.layer1.layers.strategies.interfaces.CustomGeneratedEventAliased;
import velox.api.layer1.layers.utils.OrderBook;
import velox.api.layer1.messages.indicators.StrategyUpdateGenerator;
import velox.api.layer1.messages.indicators.StrategyUpdateGeneratorFilter;
import velox.api.layer1.messages.indicators.StrategyUpdateGeneratorSkipper;
import velox.api.layer1.simplified.InstanceWrapper;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;

public class DeactivatableStrategyUpdateGeneratorWithFilter
implements StrategyUpdateGenerator,
StrategyUpdateGeneratorFilter,
StrategyUpdateGeneratorSkipper {
    private SimplifiedL1ApiLoader simplifiedL1ApiLoader;
    private String targetAlias;
    private InstanceWrapper listener;
    private boolean deactivated = false;
    private boolean isRealtime = false;
    private Map<String, OrderBook> orderBooksInGenerator = new HashMap<String, OrderBook>();
    private Map<String, Set<String>> activeOrdersInGenerator = new HashMap<String, Set<String>>();
    private Consumer<CustomGeneratedEventAliased> consumer;
    private long realtimeTransferTime = Long.MAX_VALUE;

    public DeactivatableStrategyUpdateGeneratorWithFilter(SimplifiedL1ApiLoader simplifiedL1ApiLoader, String targetAlias, InstanceWrapper listener) {
        this.simplifiedL1ApiLoader = simplifiedL1ApiLoader;
        this.targetAlias = targetAlias;
        this.listener = listener;
    }

    public void setGeneratedEventsConsumer(Consumer<CustomGeneratedEventAliased> consumer) {
        this.consumer = consumer;
    }

    public Consumer<CustomGeneratedEventAliased> getGeneratedEventsConsumer() {
        return this.consumer;
    }

    public void onStatus(StatusInfo statusInfo) {
        if (this.eventShouldBePublished()) {
            this.listener.onStatus(statusInfo, true);
        }
    }

    public void onOrderUpdated(OrderInfoUpdate orderInfoUpdate) {
        if (this.eventShouldBePublished()) {
            this.listener.onOrderUpdated(orderInfoUpdate, true);
        }
    }

    public void onOrderExecuted(ExecutionInfo executionInfo) {
        if (this.eventShouldBePublished()) {
            this.listener.onOrderExecuted(executionInfo, true);
        }
    }

    public void onBalance(BalanceInfo balanceInfo) {
        if (this.eventShouldBePublished()) {
            this.listener.onBalance(balanceInfo, true);
        }
    }

    public void onTrade(String alias, double price, int size, TradeInfo tradeInfo) {
        if (this.eventShouldBePublished()) {
            this.listener.onTrade(alias, price, size, tradeInfo, true);
        }
    }

    public void onMarketMode(String alias, MarketMode marketMode) {
    }

    public void onDepth(String alias, boolean isBid, int price, int size) {
        if (this.eventShouldBePublished()) {
            if (this.isInterestedInAlias(alias) && this.isInterestedInMbp()) {
                this.orderBooksInGenerator.get(alias).onUpdate(isBid, price, (long)size);
            }
            this.listener.onDepth(alias, isBid, price, size, true);
        }
    }

    public void onMboSend(String alias, String orderId, boolean isBid, int price, int size) {
        if (this.eventShouldBePublished()) {
            if (this.isInterestedInAlias(alias) && this.isInterestedInMbo() && !this.activeOrdersInGenerator.get(alias).add(orderId)) {
                throw new IllegalStateException("Adding same order ID twice (" + orderId + "@" + alias + ")");
            }
            this.listener.send(alias, orderId, isBid, price, size, true);
        }
    }

    public void onMboReplace(String alias, String orderId, int price, int size) {
        if (this.eventShouldBePublished()) {
            this.listener.replace(alias, orderId, price, size, true);
        }
    }

    public void onMboCancel(String alias, String orderId) {
        if (this.eventShouldBePublished()) {
            if (this.isInterestedInAlias(alias) && this.isInterestedInMbo() && !this.activeOrdersInGenerator.get(alias).remove(orderId)) {
                throw new IllegalStateException("Order ID does not exist (" + orderId + "@" + alias + ")");
            }
            this.listener.cancel(alias, orderId, true);
        }
    }

    public void onInstrumentAdded(String alias, InstrumentInfo instrumentInfo) {
        if (this.eventShouldBePublished()) {
            if (this.isInterestedInAlias(alias)) {
                Set oldMboOrders;
                OrderBook oldOrderBook;
                if (this.isInterestedInMbp() && (oldOrderBook = this.orderBooksInGenerator.put(alias, new OrderBook())) != null) {
                    oldOrderBook.getBidMap().keySet().forEach(price -> this.listener.onDepth(alias, true, (int)price, 0, true));
                    oldOrderBook.getAskMap().keySet().forEach(price -> this.listener.onDepth(alias, false, (int)price, 0, true));
                }
                if (this.isInterestedInMbo() && (oldMboOrders = (Set)this.activeOrdersInGenerator.put(alias, new HashSet())) != null) {
                    oldMboOrders.forEach(orderId -> this.listener.cancel(alias, (String)orderId, true));
                }
            }
            this.listener.onInstrumentAdded(alias, instrumentInfo, true);
        }
    }

    public void onInstrumentRemoved(String alias) {
    }

    public void onInstrumentNotFound(String symbol, String exchange, String type) {
    }

    public void onInstrumentAlreadySubscribed(String symbol, String exchange, String type) {
    }

    public void onUserMessage(Object data) {
    }

    public void setTime(long time) {
        if (this.simplifiedL1ApiLoader.mode == SimplifiedL1ApiLoader.Mode.MIXED && !this.isRealtime) {
            if (this.realtimeTransferTime == Long.MAX_VALUE && time >= this.simplifiedL1ApiLoader.getCurrentTime()) {
                this.realtimeTransferTime = time + 1L;
            }
            if (time >= this.realtimeTransferTime) {
                this.isRealtime = true;
                this.listener.onRealtimeStart(time);
            }
        }
        if (!this.isRealtime) {
            this.listener.setTime(time, true);
        }
    }

    public Set<StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType> getGeneratorUpdateTypes() {
        HashSet<StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType> types = new HashSet<StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType>();
        types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.INSTRUMENTS);
        types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.TRADES);
        types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.ORDERS);
        if (this.isInterestedInMbp()) {
            types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.DEPTH_MBP);
        }
        if (this.isInterestedInMbo()) {
            types.add(StrategyUpdateGeneratorFilter.StrategyUpdateGeneratorEventType.DEPTH_MBO);
        }
        return types;
    }

    private boolean isInterestedInMbo() {
        return this.listener.marketByOrderDepthDataListeners.size() > 0;
    }

    private boolean isInterestedInMbp() {
        return this.listener.depthDataListeners.size() + this.listener.bboDataListeners.size() + this.listener.barDataListeners.size() > 0;
    }

    public Set<String> getGeneratorAliases() {
        if (this.simplifiedL1ApiLoader.multiInstrument) {
            return null;
        }
        return Collections.singleton(this.targetAlias);
    }

    private boolean isInterestedInAlias(String alias) {
        return this.simplifiedL1ApiLoader.multiInstrument || alias.equals(this.targetAlias);
    }

    public void deactivate() {
        this.deactivated = true;
    }

    public boolean isActive() {
        return !this.deactivated;
    }

    private boolean eventShouldBePublished() {
        return this.isActive() && !this.skipToRealtimeRequested();
    }

    public boolean skipToRealtimeRequested() {
        return this.simplifiedL1ApiLoader.mode != SimplifiedL1ApiLoader.Mode.GENERATORS && this.isRealtime;
    }
}

